/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import zeenea.connector.commons.cache.ByteIterator;
import zeenea.connector.commons.cache.CacheAddress;
import zeenea.connector.commons.cache.CachePage;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.Page;

class DataPage
extends CachePage {
    private static final int MIN_PAYLOAD_LENGTH = 8;
    private static final int FREE_SPACE_INDEX = 1;
    private static final int HEADER_LENGTH = 3;
    private static final int ENTRY_HEADER_LENGTH = 8;
    private static final int ENTRY_MORE_ADDRESS_INDEX = 2;
    private static final int ENTRY_CONTENT_INDEX = 8;

    DataPage(CachePageLoader pageLoader, int pageNumber) {
        super(pageLoader, pageNumber);
    }

    static DataPage of(CachePageLoader pageLoader, int pageNumber) {
        return new DataPage(pageLoader, pageNumber);
    }

    static DataPage init(CachePageLoader pageLoader, Page page) {
        DataPage dataPage = new DataPage(pageLoader, page.number());
        page.put(0, (byte)68);
        dataPage.freeSpaceIndex(page, 3);
        return dataPage;
    }

    int freeSpaceIndex() {
        return this.applyToPageAsInt(this::freeSpaceIndex);
    }

    private int freeSpaceIndex(Page page) {
        return page.getShort(1) & 0xFFFF;
    }

    private void freeSpaceIndex(Page page, int index) {
        page.putShort(1, (short)index);
    }

    int freePayloadSpace() {
        return this.applyToPageAsInt(this::freePayloadSpace);
    }

    int freePayloadSpace(Page page) {
        return 4096 - this.freeSpaceIndex(page) - 8;
    }

    boolean hasMoreSpace() {
        return this.freePayloadSpace() > 8;
    }

    void read(int index, ByteBuffer buffer) {
        this.consumePage(page -> {
            int len = page.getShort(index) & 0xFFFF;
            if (len < buffer.remaining()) {
                int oldLimit = buffer.limit();
                buffer.limit(buffer.position() + len);
                page.get(index + 8, buffer);
                buffer.limit(oldLimit);
            } else {
                page.get(index + 8, buffer);
            }
        });
    }

    int length(int index) {
        return this.applyToPageAsInt(page -> page.getShort(index) & 0xFFFF);
    }

    CacheAddress more(int index) {
        return this.applyToPage(page -> CacheAddress.readFrom(page, index + 2));
    }

    void write(ByteIterator data, CacheAddress more) {
        this.consumePage(page -> {
            int availableSpace;
            long remaining = data.remaining();
            int len = remaining < (long)(availableSpace = this.freePayloadSpace((Page)page)) ? (int)remaining : availableSpace;
            int entryIndex = this.freeSpaceIndex((Page)page);
            page.putShort(entryIndex, (short)len);
            more.writeTo((Page)page, entryIndex + 2);
            this.freeSpaceIndex((Page)page, entryIndex + 8 + len);
            page.put(entryIndex + 8, data, len);
        });
    }

    @Override
    byte code() {
        return 68;
    }

    public String toString() {
        return String.format("DataPage %1$d (0x%1$x)", this.pageNumber());
    }
}

