/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.Page;

abstract class CachePage {
    static final byte BTREE_NODE_CODE = 78;
    static final byte BTREE_LEAF_CODE = 76;
    static final byte DATA_CODE = 68;
    private final CachePageLoader pageLoader;
    private final int pageNumber;

    CachePage(CachePageLoader pageLoader, int pageNumber) {
        this.pageLoader = pageLoader;
        this.pageNumber = pageNumber;
    }

    static String displayCode(byte code) {
        String name;
        switch (code) {
            case 76: {
                name = "BTREE_LEAF";
                break;
            }
            case 78: {
                name = "BTREE_NODE";
                break;
            }
            case 68: {
                name = "DATA";
                break;
            }
            default: {
                name = "UNKNOWN";
            }
        }
        return String.format("%1$x (%1$s - %2$s)", code, name);
    }

    abstract byte code();

    CachePageLoader pageLoader() {
        return this.pageLoader;
    }

    int pageNumber() {
        return this.pageNumber;
    }

    <T> T applyToPage(Function<Page, T> function) {
        return this.pageLoader.pageLoader().applyToPage(this.pageNumber, function);
    }

    int applyToPageAsInt(ToIntFunction<Page> function) {
        return this.pageLoader.pageLoader().applyToPageAsInt(this.pageNumber, function);
    }

    void consumePage(Consumer<Page> consumer) {
        this.pageLoader.pageLoader().consumePage(this.pageNumber, consumer);
    }

    boolean testPage(Predicate<Page> predicate) {
        return this.pageLoader.pageLoader().testPage(this.pageNumber, predicate);
    }
}

