/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import zeenea.connector.commons.cache.BTreeEntry;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.Page;

final class BTreeLeafEntry
extends BTreeEntry {
    private final DataEntry valueEntry;

    private BTreeLeafEntry(DataEntry keyEntry, DataEntry valueEntry) {
        super(keyEntry);
        this.valueEntry = valueEntry;
    }

    static BTreeLeafEntry of(CacheData key, CacheData value) {
        DataEntry keyEntry = DataEntry.of(key);
        DataEntry valueEntry = DataEntry.of(value);
        return new BTreeLeafEntry(keyEntry, valueEntry);
    }

    static BTreeLeafEntry of(Page page, int entryIndex) {
        DataEntry keyEntry = DataEntry.of(page, entryIndex);
        DataEntry valueEntry = DataEntry.of(page, entryIndex + keyEntry.localEntryLength());
        return new BTreeLeafEntry(keyEntry, valueEntry);
    }

    @Override
    void setEntryIndex(int entryIndex) {
        this.keyEntry().setEntryIndex(entryIndex);
        this.valueEntry.setEntryIndex(entryIndex + this.keyEntry().localEntryLength());
    }

    DataEntry valueEntry() {
        return this.valueEntry;
    }

    @Override
    int localEntryLength() {
        return this.keyEntry().localEntryLength() + this.valueEntry().localEntryLength();
    }
}

