/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.BinomialBoundsN;
import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactOrderedSketch;
import org.apache.datasketches.theta.DirectCompactUnorderedSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.ForwardCompatibility;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.HeapCompactOrderedSketch;
import org.apache.datasketches.theta.HeapCompactUnorderedSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.UpdateSketch;

public abstract class Sketch {
    static final int DEFAULT_LG_RESIZE_FACTOR = 3;

    Sketch() {
    }

    public static Sketch heapify(Memory srcMem) {
        return Sketch.heapify(srcMem, 9001L);
    }

    public static Sketch heapify(Memory srcMem, long seed) {
        byte serVer = srcMem.getByte(1L);
        if (serVer == 3) {
            return Sketch.heapifyFromMemory(srcMem, seed);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seed);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, seed);
        }
        throw new SketchesArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static Sketch wrap(Memory srcMem) {
        return Sketch.wrap(srcMem, 9001L);
    }

    public static Sketch wrap(Memory srcMem, long seed) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        switch (family) {
            case QUICKSELECT: {
                if (serVer == 3 && preLongs == 3) {
                    return DirectQuickSelectSketchR.readOnlyWrap(srcMem, seed);
                }
                throw new SketchesArgumentException("Corrupted: " + (Object)((Object)family) + " family image: must have SerVer = 3 and preLongs = 3");
            }
            case COMPACT: {
                if (serVer == 3) {
                    boolean readOnly;
                    boolean compactFlag;
                    long cap = srcMem.getCapacity();
                    if (cap < 16L) {
                        return EmptyCompactSketch.getInstance(srcMem);
                    }
                    if (cap == 16L) {
                        return SingleItemSketch.heapify(srcMem, seed);
                    }
                    byte flags = srcMem.getByte(5L);
                    boolean orderedFlag = (flags & 0x10) > 0;
                    boolean bl = compactFlag = (flags & 8) > 0;
                    if (!compactFlag) {
                        throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
                    }
                    boolean bl2 = readOnly = (flags & 2) > 0;
                    if (!readOnly) {
                        throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
                    }
                    return orderedFlag ? DirectCompactOrderedSketch.wrapInstance(srcMem, seed) : DirectCompactUnorderedSketch.wrapInstance(srcMem, seed);
                }
                if (serVer == 1) {
                    return ForwardCompatibility.heapify1to3(srcMem, seed);
                }
                if (serVer == 2) {
                    return ForwardCompatibility.heapify2to3(srcMem, seed);
                }
                throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
            }
        }
        throw new SketchesArgumentException("Sketch cannot wrap family: " + (Object)((Object)family) + " as a Sketch");
    }

    public abstract CompactSketch compact();

    public abstract CompactSketch compact(boolean var1, WritableMemory var2);

    public int getCountLessThanTheta(double theta) {
        long thetaLong = (long)(9.223372036854776E18 * theta);
        return HashOperations.count(this.getCache(), thetaLong);
    }

    public abstract int getCurrentBytes(boolean var1);

    public abstract double getEstimate();

    public abstract Family getFamily();

    public abstract HashIterator iterator();

    public double getLowerBound(int numStdDev) {
        return this.isEstimationMode() ? Sketch.lowerBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public static int getMaxCompactSketchBytes(int numberOfEntries) {
        if (numberOfEntries == 0) {
            return 8;
        }
        if (numberOfEntries == 1) {
            return 16;
        }
        return (numberOfEntries << 3) + 24;
    }

    public static int getMaxUpdateSketchBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.QUICKSELECT.getMaxPreLongs() << 3);
    }

    public int getRetainedEntries() {
        return this.getRetainedEntries(true);
    }

    public abstract int getRetainedEntries(boolean var1);

    public static int getSerializationVersion(Memory mem) {
        return mem.getByte(1L);
    }

    public double getTheta() {
        return (double)this.getThetaLong() / 9.223372036854776E18;
    }

    public abstract long getThetaLong();

    public double getUpperBound(int numStdDev) {
        return this.isEstimationMode() ? Sketch.upperBound(this.getRetainedEntries(true), this.getThetaLong(), numStdDev, this.isEmpty()) : (double)this.getRetainedEntries(true);
    }

    public abstract boolean hasMemory();

    public abstract boolean isCompact();

    public abstract boolean isDirect();

    public abstract boolean isEmpty();

    public boolean isEstimationMode() {
        return Sketch.estMode(this.getThetaLong(), this.isEmpty());
    }

    public abstract boolean isOrdered();

    public boolean isSameResource(Memory that) {
        return false;
    }

    public abstract byte[] toByteArray();

    public String toString() {
        return this.toString(true, false, 8, true);
    }

    public String toString(boolean sketchSummary, boolean dataDetail, int width, boolean hexMode) {
        StringBuilder sb = new StringBuilder();
        long[] cache = this.getCache();
        int nomLongs = 0;
        int arrLongs = cache.length;
        float p = 0.0f;
        int rf = 0;
        boolean updateSketch = this instanceof UpdateSketch;
        long thetaLong = this.getThetaLong();
        int curCount = this.getRetainedEntries(true);
        if (updateSketch) {
            UpdateSketch uis = (UpdateSketch)this;
            nomLongs = 1 << uis.getLgNomLongs();
            arrLongs = 1 << uis.getLgArrLongs();
            p = uis.getP();
            rf = uis.getResizeFactor().getValue();
        }
        if (dataDetail) {
            int w;
            int n = w = width > 0 ? width : 8;
            if (curCount > 0) {
                sb.append("### SKETCH DATA DETAIL");
                int j = 0;
                for (int i = 0; i < arrLongs; ++i) {
                    long h = cache[i];
                    if (h <= 0L || h >= thetaLong) continue;
                    if (j % w == 0) {
                        sb.append(Util.LS).append(String.format("   %6d", j + 1));
                    }
                    if (hexMode) {
                        sb.append(" " + Util.zeroPad(Long.toHexString(h), 16) + ",");
                    } else {
                        sb.append(String.format(" %20d,", h));
                    }
                    ++j;
                }
                sb.append(Util.LS).append("### END DATA DETAIL").append(Util.LS + Util.LS);
            }
        }
        if (sketchSummary) {
            double thetaDbl = (double)thetaLong / 9.223372036854776E18;
            String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
            String thisSimpleName = this.getClass().getSimpleName();
            int seedHash = Short.toUnsignedInt(this.getSeedHash());
            sb.append(Util.LS);
            sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
            if (updateSketch) {
                sb.append("   Nominal Entries (k)     : ").append(nomLongs).append(Util.LS);
            }
            sb.append("   Estimate                : ").append(this.getEstimate()).append(Util.LS);
            sb.append("   Upper Bound, 95% conf   : ").append(this.getUpperBound(2)).append(Util.LS);
            sb.append("   Lower Bound, 95% conf   : ").append(this.getLowerBound(2)).append(Util.LS);
            if (updateSketch) {
                sb.append("   p                       : ").append(p).append(Util.LS);
            }
            sb.append("   Theta (double)          : ").append(thetaDbl).append(Util.LS);
            sb.append("   Theta (long)            : ").append(thetaLong).append(Util.LS);
            sb.append("   Theta (long) hex        : ").append(thetaHex).append(Util.LS);
            sb.append("   EstMode?                : ").append(this.isEstimationMode()).append(Util.LS);
            sb.append("   Empty?                  : ").append(this.isEmpty()).append(Util.LS);
            if (updateSketch) {
                sb.append("   Resize Factor           : ").append(rf).append(Util.LS);
                sb.append("   Array Size Entries      : ").append(arrLongs).append(Util.LS);
            }
            sb.append("   Retained Entries        : ").append(curCount).append(Util.LS);
            sb.append("   Seed Hash               : ").append(Integer.toHexString(seedHash)).append(" | ").append(seedHash).append(Util.LS);
            sb.append("### END SKETCH SUMMARY").append(Util.LS);
        }
        return sb.toString();
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.preambleToString(byteArr);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.preambleToString(mem);
    }

    abstract long[] getCache();

    int getCurrentDataLongs(boolean compact) {
        return this.isCompact() || compact ? this.getRetainedEntries(true) : 1 << ((UpdateSketch)this).getLgArrLongs();
    }

    abstract int getCurrentPreambleLongs(boolean var1);

    static final int computeCompactPreLongs(long thetaLong, boolean empty, int curCount) {
        return thetaLong < Long.MAX_VALUE ? 3 : (empty ? 1 : (curCount > 1 ? 2 : 1));
    }

    abstract Memory getMemory();

    abstract short getSeedHash();

    static final boolean isValidSketchID(int id) {
        return id == Family.ALPHA.getID() || id == Family.QUICKSELECT.getID() || id == Family.COMPACT.getID();
    }

    static final void checkSketchAndMemoryFlags(Sketch sketch) {
        Memory mem = sketch.getMemory();
        if (mem == null) {
            return;
        }
        int flags = PreambleUtil.extractFlags(mem);
        if ((flags & 8) > 0 ^ sketch.isCompact()) {
            throw new SketchesArgumentException("Possible corruption: Memory Compact Flag inconsistent with Sketch");
        }
        if ((flags & 0x10) > 0 ^ sketch.isOrdered()) {
            throw new SketchesArgumentException("Possible corruption: Memory Ordered Flag inconsistent with Sketch");
        }
    }

    static final long thetaOnCompact(boolean empty, int curCount, long thetaLong) {
        return empty && curCount == 0 && thetaLong < Long.MAX_VALUE ? Long.MAX_VALUE : thetaLong;
    }

    static final boolean emptyFromCountAndTheta(int curCount, long thetaLong) {
        return curCount == 0 && thetaLong == Long.MAX_VALUE;
    }

    static final double estimate(long thetaLong, int curCount) {
        return (double)curCount * (9.223372036854776E18 / (double)thetaLong);
    }

    static final double lowerBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getLowerBound(curCount, theta, numStdDev, empty);
    }

    static final double upperBound(int curCount, long thetaLong, int numStdDev, boolean empty) {
        double theta = (double)thetaLong / 9.223372036854776E18;
        return BinomialBoundsN.getUpperBound(curCount, theta, numStdDev, empty);
    }

    private static final boolean estMode(long thetaLong, boolean empty) {
        return thetaLong < Long.MAX_VALUE && !empty;
    }

    private static final Sketch heapifyFromMemory(Memory srcMem, long seed) {
        long cap = srcMem.getCapacity();
        if (cap < 8L) {
            throw new SketchesArgumentException("Corrupted: valid sketch must be at least 8 bytes.");
        }
        byte familyID = srcMem.getByte(2L);
        Family family = Family.idToFamily(familyID);
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        boolean orderedFlag = (flags & 0x10) != 0;
        boolean compactFlag = (flags & 8) != 0;
        switch (family) {
            case ALPHA: {
                if (compactFlag) {
                    throw new SketchesArgumentException("Corrupted: ALPHA family image: cannot be compact");
                }
                return HeapAlphaSketch.heapifyInstance(srcMem, seed);
            }
            case QUICKSELECT: {
                return HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
            }
            case COMPACT: {
                boolean readOnly;
                if (!compactFlag) {
                    throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
                }
                boolean bl = readOnly = (flags & 2) != 0;
                if (!readOnly) {
                    throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
                }
                boolean empty = PreambleUtil.isEmpty(srcMem);
                if (empty) {
                    return EmptyCompactSketch.getInstance(srcMem);
                }
                if (preLongs == 1) {
                    short computedSeedHash;
                    short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
                    if (memSeedHash == (computedSeedHash = Util.computeSeedHash(seed)) && orderedFlag) {
                        return SingleItemSketch.heapify(srcMem, seed);
                    }
                    return EmptyCompactSketch.getInstance(srcMem);
                }
                return orderedFlag ? HeapCompactOrderedSketch.heapifyInstance(srcMem, seed) : HeapCompactUnorderedSketch.heapifyInstance(srcMem, seed);
            }
        }
        throw new SketchesArgumentException("Sketch cannot heapify family: " + (Object)((Object)family) + " as a Sketch");
    }
}

