/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.HeaderPage;
import zeenea.connector.commons.cache.TableDesc;
import zeenea.connector.commons.cache.ZeeCacheTableWriter;

public final class ZeeCacheWriter {
    @NotNull
    private final CachePageLoader pageLoader;
    @NotNull
    private final HeaderPage headerPage;
    private final Map<CacheData, ZeeCacheTableWriter> tables = new HashMap<CacheData, ZeeCacheTableWriter>();

    public ZeeCacheWriter(@NotNull CachePageLoader pageLoader, @NotNull HeaderPage headerPage) {
        this.pageLoader = pageLoader;
        this.headerPage = headerPage;
    }

    public ZeeCacheTableWriter table(String name) {
        return this.tables.computeIfAbsent(CacheData.of(name), tk -> ZeeCacheTableWriter.create(this.pageLoader, tk));
    }

    void close() {
        BTreeLeafPage tableTree = this.pageLoader.initHeaderBTreeLeafPage();
        ZeeCacheTableWriter rootTableWriter = ZeeCacheTableWriter.rootTable(this.pageLoader, tableTree, this.tables.size());
        for (ZeeCacheTableWriter tableWriter : this.tables.values()) {
            CacheData tableKey = tableWriter.tableKey();
            TableDesc tableDesc = tableWriter.tableDesc();
            rootTableWriter.add(tableKey, tableDesc.toCacheData());
        }
        TableDesc rootTableDesc = rootTableWriter.tableDesc();
        this.headerPage.rootTable(rootTableDesc);
    }
}

