/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.Objects;
import zeenea.connector.commons.cache.Page;

final class CacheAddress {
    static final CacheAddress INVALID = new CacheAddress(-1, -1);
    static final int BYTES = 6;
    private final int page;
    private final short index;

    private CacheAddress(int page, short index) {
        if (index > 4096) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.page = page;
        this.index = index;
    }

    static CacheAddress of(int page, int index) {
        return new CacheAddress(page, (short)index);
    }

    static CacheAddress of(int page, short index) {
        return new CacheAddress(page, index);
    }

    static CacheAddress readFrom(Page page, int index) {
        int addrNumber = page.getInt(index);
        short addrIndex = page.getShort(index + 4);
        return CacheAddress.of(addrNumber, addrIndex);
    }

    void writeTo(Page page, int index) {
        page.putInt(index, this.page);
        page.putShort(index + 4, this.index);
    }

    public int page() {
        return this.page;
    }

    public int index() {
        return this.index;
    }

    public boolean isValid() {
        return this.page != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheAddress that = (CacheAddress)o;
        return this.page == that.page && this.index == that.index;
    }

    public int hashCode() {
        return Objects.hash(this.page, this.index);
    }

    public String toString() {
        return this.page + ":" + this.index;
    }
}

