/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.BTreeEntry;
import zeenea.connector.commons.cache.BTreeFindResult;
import zeenea.connector.commons.cache.ByteIterator;
import zeenea.connector.commons.cache.CacheAddress;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CachePage;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.Page;

abstract class BTreePage
extends CachePage {
    BTreePage(CachePageLoader pageLoader, int pageNumber) {
        super(pageLoader, pageNumber);
    }

    abstract boolean isLeaf();

    abstract int entryCount();

    abstract boolean isLast(int var1);

    protected abstract int entryCount(Page var1);

    protected abstract void setEntryCount(Page var1, int var2);

    protected abstract int entryPointerIndex(int var1);

    protected abstract int entryDataZone(Page var1);

    protected abstract void setEntryDataZone(Page var1, int var2);

    @NotNull
    protected abstract CacheData key(Page var1, int var2);

    protected final void checkEntryNumber(Page page, int entryNumber, boolean strict) {
        if (entryNumber < 0) {
            throw new IndexOutOfBoundsException("Negative entry number " + entryNumber + " for page " + this.pageNumber());
        }
        int count = this.entryCount(page);
        if (entryNumber > count || strict && entryNumber == count) {
            throw new IndexOutOfBoundsException("Entry number too large " + entryNumber + (strict ? " >= " : " > ") + count + " for page " + this.pageNumber());
        }
    }

    protected final int entryIndex(Page page, int entryNumber) {
        return page.getShort(this.entryPointerIndex(entryNumber)) & 0xFFFF;
    }

    protected final int entryIndex(int entryNumber) {
        return this.applyToPageAsInt(page -> this.entryIndex((Page)page, entryNumber));
    }

    final BTreeFindResult findEntry(@NotNull CacheData key) {
        return this.applyToPage(page -> {
            int first = 0;
            int last = this.entryCount((Page)page) - 1;
            while (first <= last) {
                int middle = (first + last) / 2;
                CacheData middleKey = this.key((Page)page, middle);
                int compare = middleKey.compareTo(key);
                if (compare < 0) {
                    first = middle + 1;
                    continue;
                }
                if (compare > 0) {
                    last = middle - 1;
                    continue;
                }
                return new BTreeFindResult(true, middle);
            }
            return new BTreeFindResult(false, first);
        });
    }

    final CacheAddress more(DataEntry entry) {
        return entry.overflow() ? this.applyToPage(page -> CacheAddress.readFrom(page, entry.moreIndex())) : CacheAddress.INVALID;
    }

    final int freeSpace() {
        return this.applyToPageAsInt(this::freeSpace);
    }

    protected final int freeSpace(Page page) {
        int entryDataZone = this.entryDataZone(page);
        int entryListEnd = this.entryPointerIndex(this.entryCount(page));
        return entryDataZone - entryListEnd;
    }

    final boolean notEnoughSpace(BTreeEntry entry) {
        return this.testPage(page -> {
            int freeSpace;
            int requiredSpace = entry.localEntryLength() + 2;
            return requiredSpace > (freeSpace = this.freeSpace((Page)page));
        });
    }

    final void readData(DataEntry entry, ByteBuffer buffer) {
        this.readEntrySegment(entry.dataIndex(), entry.localDataLength(), buffer);
    }

    protected final void readEntrySegment(int index, int length, ByteBuffer buffer) {
        if (length == 0) {
            return;
        }
        if (buffer.remaining() <= length) {
            this.consumePage(page -> page.get(index, buffer));
        } else {
            int saveLimit = buffer.limit();
            buffer.limit(buffer.position() + length);
            this.consumePage(page -> page.get(index, buffer));
            buffer.limit(saveLimit);
        }
    }

    final void insertNewEntry(int entryNumber, BTreeEntry entry) {
        this.consumePage(page -> {
            this.checkEntryNumber((Page)page, entryNumber, false);
            int newEntryIndex = this.entryDataZone((Page)page) - entry.localEntryLength();
            entry.setEntryIndex(newEntryIndex);
            int newEntryPointer = this.entryPointerIndex(entryNumber);
            int lastEntryPointer = this.entryPointerIndex(this.entryCount((Page)page));
            int blockLen = lastEntryPointer - newEntryPointer;
            byte[] block = new byte[blockLen];
            page.get(newEntryPointer, block);
            page.put(newEntryPointer + 2, block);
            page.putShort(newEntryPointer, (short)newEntryIndex);
            this.setEntryCount((Page)page, this.entryCount((Page)page) + 1);
            this.setEntryDataZone((Page)page, newEntryIndex);
        });
    }

    final void writeLocalData(DataEntry entry, CacheAddress more, ByteIterator data) {
        this.consumePage(page -> {
            page.putVarInt(entry.entryIndex(), entry.varLength());
            if (entry.overflow()) {
                more.writeTo((Page)page, entry.moreIndex());
            }
            page.put(entry.dataIndex(), data, entry.localDataLength());
        });
    }

    abstract BTreeEntry entry(int var1);

    protected abstract BTreeEntry entry(Page var1, int var2);

    protected final void copyTo(Page page, BTreePage target, int from) {
        target.consumePage(targetPage -> {
            int targetEntryIndex = 4096;
            int targetEntryPointerIndex = this.entryPointerIndex(0);
            int copyCount = this.entryCount(page) - from;
            for (int i = 0; i < copyCount; ++i) {
                BTreeEntry entry = this.entry(page, from + i);
                targetPage.copyFrom(targetEntryIndex -= entry.localEntryLength(), page, entry.entryIndex(), entry.localEntryLength());
                targetPage.putShort(targetEntryPointerIndex, (short)targetEntryIndex);
                targetEntryPointerIndex += 2;
            }
            target.setEntryCount((Page)targetPage, copyCount);
            target.setEntryDataZone((Page)targetPage, targetEntryIndex);
        });
    }

    protected final void compact(Page page, int count) {
        int oldCount = this.entryCount(page);
        if (oldCount == count) {
            return;
        }
        if (count > 0) {
            ArrayList<Integer> entryNumbers = new ArrayList<Integer>(count);
            ArrayList<BTreeEntry> entries = new ArrayList<BTreeEntry>(count);
            for (int i = 0; i < count; ++i) {
                entryNumbers.add(i);
                entries.add(this.entry(page, i));
            }
            this.doCompact(page, entryNumbers, entries, 4096);
        }
        this.setEntryCount(page, count);
        page.zero(this.entryPointerIndex(count), this.entryDataZone(page));
    }

    protected final void doCompact(Page page, List<Integer> entryNumbers, List<BTreeEntry> entries, int newEntryIndex) {
        entryNumbers.sort(Comparator.comparingInt(i -> ((BTreeEntry)entries.get((int)i)).entryIndex()).reversed());
        int longestEntry = entries.stream().filter(Objects::nonNull).mapToInt(BTreeEntry::localEntryLength).max().orElse(0);
        byte[] buffer = new byte[longestEntry];
        for (int i2 : entryNumbers) {
            BTreeEntry entry = entries.get(i2);
            int len = entry.localEntryLength();
            int oldEntryIndex = entry.entryIndex();
            if (oldEntryIndex != (newEntryIndex -= len)) {
                page.get(oldEntryIndex, buffer, 0, len);
                page.put(newEntryIndex, buffer, 0, len);
            }
            page.putShort(this.entryPointerIndex(i2), (short)newEntryIndex);
        }
        this.setEntryDataZone(page, newEntryIndex);
    }
}

