/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.StringJoiner;
import zeenea.connector.commons.cache.BTreeEntry;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.Page;

final class BTreeNodeEntry
extends BTreeEntry {
    BTreeNodeEntry(DataEntry keyEntry) {
        super(keyEntry);
    }

    static BTreeNodeEntry of(CacheData key) {
        return new BTreeNodeEntry(DataEntry.of(key));
    }

    static BTreeNodeEntry of(int keyLength) {
        return new BTreeNodeEntry(DataEntry.of(keyLength));
    }

    static BTreeNodeEntry of(Page page, int entryIndex) {
        DataEntry keyEntry = DataEntry.of(page, entryIndex);
        return new BTreeNodeEntry(keyEntry);
    }

    @Override
    void setEntryIndex(int entryIndex) {
        this.keyEntry().setEntryIndex(entryIndex);
    }

    int childRelatifIndex() {
        return this.keyEntry().localEntryLength();
    }

    int childLength() {
        return 4;
    }

    int childIndex() {
        return this.entryIndex() + this.childRelatifIndex();
    }

    @Override
    int localEntryLength() {
        return this.keyEntry().localEntryLength() + this.childLength();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "BTreeNodeEntry(", ")");
        if (this.hasEntryIndex()) {
            int entryIndex = this.entryIndex();
            joiner.add("entry_index=" + entryIndex + " (" + Integer.toHexString(entryIndex) + ")");
        }
        joiner.add("local_entry_length=" + this.localEntryLength()).add("key_data_length=" + this.keyEntry().dataLength()).add("key_overflow=" + this.keyEntry().overflow()).add("key_local_data_length=" + this.keyEntry().localDataLength()).add("key_local_entry_length=" + this.keyEntry().localEntryLength());
        joiner.add("child_relative_index=" + this.childRelatifIndex());
        if (this.hasEntryIndex()) {
            int childIndex = this.childIndex();
            joiner.add("child_index=" + childIndex + " (" + Integer.toHexString(childIndex) + ")");
        }
        return joiner.toString();
    }
}

