/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.MapNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.MapWritableBufferImpl;
import org.apache.datasketches.memory.MapWritableMemoryImpl;
import org.apache.datasketches.memory.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.StepBoolean;

final class MapNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private static final int id = 48;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final byte typeId;

    MapNonNativeWritableMemoryImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.typeId = (byte)(0x30 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return MapNonNativeWritableMemoryImpl.isNativeByteOrder(byteOrder) ? new MapWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid) : new MapNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | (readOnly ? (byte)1 : 0);
        return MapNonNativeWritableMemoryImpl.isNativeByteOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this);
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

