/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BBNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.BBWritableBufferImpl;
import org.apache.datasketches.memory.BBWritableMemoryImpl;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.NonNativeWritableMemoryImpl;

final class BBNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private static final int id = 56;
    private final Object unsafeObj;
    private final long nativeBaseOffset;
    private final ByteBuffer byteBuf;
    private final byte typeId;

    BBNonNativeWritableMemoryImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, ByteBuffer byteBuf) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
        this.unsafeObj = unsafeObj;
        this.nativeBaseOffset = nativeBaseOffset;
        this.byteBuf = byteBuf;
        this.typeId = (byte)(0x38 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return BBNonNativeWritableMemoryImpl.isNativeByteOrder(byteOrder) ? new BBWritableMemoryImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.getByteBuffer()) : new BBNonNativeWritableMemoryImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.getByteBuffer());
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | (readOnly ? (byte)1 : 0);
        return BBNonNativeWritableMemoryImpl.isNativeByteOrder(byteOrder) ? new BBWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.byteBuf, this) : new BBNonNativeWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.byteBuf, this);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.assertValid();
        return this.byteBuf;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    Object getUnsafeObject() {
        this.assertValid();
        return this.unsafeObj;
    }
}

