/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.processor;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.immutables.processor.CallStack;
import org.immutables.value.internal.$processor$.$Processor;

public final class ProxyProcessor
implements Processor {
    private static final String DELEGATE_CLASS = "org.immutables.value.internal.$processor$.$Processor";
    private static final String ECLIPSE_PACKAGE_PREFIX = "org.eclipse.";
    private static final String OSGI_SYSTEM_PROPERTY = "osgi.arch";
    private static volatile ClassLoader cachedProxyClassLoader;
    private final Processor delegate = ProxyProcessor.requiresClassLoaderDelegate() ? ProxyProcessor.createClassLoaderDelegate() : ProxyProcessor.createDefaultDelegate();

    @Override
    public Set<String> getSupportedOptions() {
        return this.delegate.getSupportedOptions();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.delegate.getSupportedAnnotationTypes();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return this.delegate.getSupportedSourceVersion();
    }

    @Override
    public void init(ProcessingEnvironment processing) {
        this.delegate.init(processing);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        return this.delegate.process(annotations, round);
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return this.delegate.getCompletions(element, annotation, member, userText);
    }

    private static Processor createDefaultDelegate() {
        return new $Processor();
    }

    private static Processor createClassLoaderDelegate() {
        try {
            if (cachedProxyClassLoader == null) {
                CallStack callStack = new CallStack();
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                for (Class<?> klass : callStack.getCallingClasses()) {
                    if (klass.getClassLoader() == null || !klass.getClassLoader().getClass().getName().startsWith(ECLIPSE_PACKAGE_PREFIX)) continue;
                    loader = klass.getClassLoader();
                    break;
                }
                cachedProxyClassLoader = new ProxyClassLoader(((URLClassLoader)ProxyProcessor.class.getClassLoader()).getURLs(), loader);
            }
            return (Processor)cachedProxyClassLoader.loadClass(DELEGATE_CLASS).newInstance();
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean requiresClassLoaderDelegate() {
        if (System.getProperty(OSGI_SYSTEM_PROPERTY) != null) {
            CallStack callStack = new CallStack();
            for (Class<?> klass : callStack.getCallingClasses()) {
                ClassLoader classLoader = klass.getClassLoader();
                if (classLoader == null || !klass.getClassLoader().getClass().getName().startsWith(ECLIPSE_PACKAGE_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ProxyClassLoader
    extends URLClassLoader {
        private final ClassLoader contextLoader;

        ProxyClassLoader(URL[] urls, ClassLoader contextLoader) {
            super(urls, contextLoader);
            this.contextLoader = contextLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c;
                if (name.startsWith(ProxyProcessor.ECLIPSE_PACKAGE_PREFIX)) {
                    c = this.contextLoader.loadClass(name);
                } else {
                    c = this.findLoadedClass(name);
                    if (c == null) {
                        try {
                            c = this.findClass(name);
                        }
                        catch (ClassNotFoundException ex) {
                            return super.loadClass(name, resolve);
                        }
                    }
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
    }
}

