/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.collection;

import java.util.NoSuchElementException;
import java.util.Objects;

public final class Token<T> {
    private static final Token<?> LAST_TOKEN = new Token<Object>(Rank.LAST, null);
    private final Rank rank;
    private final T value;

    private Token(Rank rank, T value) {
        this.rank = rank;
        this.value = value;
    }

    public static <T> Token<T> of(Rank rank, T value) {
        if (rank == Rank.LAST) {
            if (value != null) {
                throw new IllegalArgumentException("Last token should have no value.");
            }
            return Token.last();
        }
        return new Token<T>(rank, value);
    }

    @Deprecated
    public static <T> Token<T> of(boolean last, T value) {
        return Token.of(last ? Rank.LAST : Rank.NEXT, value);
    }

    public static <T> Token<T> first() {
        return Token.first(null);
    }

    public static <T> Token<T> first(T value) {
        return Token.of(Rank.FIRST, value);
    }

    public static <T> Token<T> next(T value) {
        return Token.of(Rank.NEXT, value);
    }

    public static <T> Token<T> last() {
        return LAST_TOKEN;
    }

    public boolean isFirst() {
        return this.rank == Rank.FIRST;
    }

    public boolean isLast() {
        return this.rank == Rank.LAST;
    }

    public T getValue() {
        if (this.isLast()) {
            throw new NoSuchElementException("Last token");
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        return this.rank == token.rank && Objects.equals(this.value, token.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rank, this.value});
    }

    public static enum Rank {
        FIRST,
        NEXT,
        LAST;

    }
}

