/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZeeCacheConfig {
    @Nullable
    private final Path path;
    @Nullable
    private final Duration timeToLive;
    private final int memPageCount;
    private final boolean directAllocation;

    public ZeeCacheConfig(@NotNull Builder builder) {
        this.path = builder.path;
        this.timeToLive = builder.timeToLive;
        this.memPageCount = builder.memPageCount;
        this.directAllocation = builder.directAllocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ZeeCacheConfig memory() {
        return ZeeCacheConfig.builder().build();
    }

    @Nullable
    public Path path() {
        return this.path;
    }

    @Nullable
    public Duration timeToLive() {
        return this.timeToLive;
    }

    public int memPageCount() {
        return this.memPageCount;
    }

    public boolean directAllocation() {
        return this.directAllocation;
    }

    public static class Builder {
        @Nullable
        private Path path;
        @Nullable
        private Duration timeToLive;
        private int memPageCount = 2048;
        private boolean directAllocation = true;

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder path(String path) {
            this.path = path == null || path.isEmpty() || "[memory]".equals(path) ? null : Paths.get(path, new String[0]);
            return this;
        }

        public Builder timeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public Builder memPageCount(Integer memoryPageCount) {
            this.memPageCount = memoryPageCount != null ? memoryPageCount : 2048;
            return this;
        }

        public Builder directAllocation(boolean directAllocation) {
            this.directAllocation = directAllocation;
            return this;
        }

        public Builder memPageCount(int memoryPageCount) {
            this.memPageCount = memoryPageCount;
            return this;
        }

        public ZeeCacheConfig build() {
            return new ZeeCacheConfig(this);
        }
    }
}

