/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.ByteIterator;
import zeenea.connector.commons.cache.CacheAddress;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.DataPage;

public abstract class CacheData
implements Comparable<CacheData> {
    public static final CacheData EMPTY = CacheData.of(new byte[0]);

    private CacheData() {
    }

    public static CacheData of(byte[] value) {
        return new ArrayCacheData(Arrays.copyOf(value, value.length));
    }

    public static CacheData of(ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.get(bytes);
        return new ArrayCacheData(bytes);
    }

    public static CacheData of(String value) {
        return new ArrayCacheData(value.getBytes(StandardCharsets.UTF_8));
    }

    public static CacheData of(int value) {
        byte[] bytes = new byte[4];
        ByteBuffer.wrap(bytes).putInt(value);
        return new ArrayCacheData(bytes);
    }

    public static CacheData of(long value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putLong(value);
        return new ArrayCacheData(bytes);
    }

    static CacheData of(BTreePage page, DataEntry entry) {
        return new PageCacheData(page, entry);
    }

    public static CacheData empty() {
        return EMPTY;
    }

    public abstract int length();

    public abstract ByteIterator byteIterator();

    public abstract void writeTo(ByteBuffer var1);

    public abstract byte[] bytes();

    public abstract int intValue();

    public abstract long longValue();

    public abstract String stringValue();

    abstract boolean hasEntry();

    abstract DataEntry entry();

    public final ByteBuffer toByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(this.length());
        this.writeTo(bb);
        bb.flip();
        return bb;
    }

    @Override
    public int compareTo(@NotNull CacheData o) {
        ByteIterator thisBytes = this.byteIterator();
        ByteIterator otherBytes = o.byteIterator();
        while (thisBytes.hasNext() && otherBytes.hasNext()) {
            int otherByte;
            int thisByte = thisBytes.next() & 0xFF;
            int delta = Integer.signum(thisByte - (otherByte = otherBytes.next() & 0xFF));
            if (delta == 0) continue;
            return delta;
        }
        return thisBytes.hasNext() ? 1 : (otherBytes.hasNext() ? -1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheData)) {
            return false;
        }
        CacheData cacheData = (CacheData)o;
        return this.compareTo(cacheData) == 0;
    }

    public int hashCode() {
        int hashCode = 1;
        ByteIterator it = this.byteIterator();
        while (it.hasNext()) {
            hashCode = 31 * hashCode + it.next();
        }
        return hashCode;
    }

    public final String toString() {
        char[] chars = new char[32];
        ByteIterator it = this.byteIterator();
        int count = 0;
        while (count < 32 && it.hasNext()) {
            int b = it.next() & 0xFF;
            if (32 <= b && b < 127 || 160 <= b) {
                chars[count++] = (char)b;
                continue;
            }
            chars[count++] = 46;
        }
        return it.hasNext() ? new String(chars) + "..." : new String(chars, 0, count);
    }

    static class PageCacheData
    extends CacheData {
        private final CachePageLoader pageLoader;
        private final BTreePage page;
        private final DataEntry entry;

        PageCacheData(BTreePage page, DataEntry entry) {
            this.pageLoader = page.pageLoader();
            this.page = page;
            this.entry = entry;
        }

        @Override
        public int length() {
            return this.entry.dataLength();
        }

        @Override
        boolean hasEntry() {
            return true;
        }

        @Override
        DataEntry entry() {
            return this.entry;
        }

        @Override
        public ByteIterator byteIterator() {
            if (this.entry.dataLength() == 0) {
                return ByteIterator.empty();
            }
            CacheAddress next = this.page.more(this.entry);
            ByteBuffer bytes = ByteBuffer.allocate(this.entry.localDataLength());
            this.page.readData(this.entry, bytes);
            bytes.flip();
            return ByteIterator.of(this.pageLoader, next, bytes, this.entry.dataLength());
        }

        @Override
        public void writeTo(ByteBuffer buffer) {
            if (this.entry.dataLength() == 0) {
                return;
            }
            if (buffer.remaining() < this.length()) {
                throw new BufferUnderflowException();
            }
            if (!this.entry.overflow()) {
                this.page.readData(this.entry, buffer);
            } else {
                DataPage data;
                int saveLimit = buffer.limit();
                int initialPosition = buffer.position();
                this.page.readData(this.entry, buffer);
                buffer.limit(initialPosition + this.entry.dataLength());
                CacheAddress more = this.page.more(this.entry);
                do {
                    data = this.pageLoader.page(more.page(), DataPage.class);
                    data.read(more.index(), buffer);
                } while ((more = data.more(more.index())).isValid());
                buffer.limit(saveLimit);
            }
        }

        @Override
        public byte[] bytes() {
            byte[] value = new byte[this.length()];
            this.writeTo(ByteBuffer.wrap(value));
            return value;
        }

        @Override
        public int intValue() {
            if (this.length() != 4) {
                throw new NumberFormatException("Not an integer");
            }
            return this.toByteBuffer().getInt();
        }

        @Override
        public long longValue() {
            if (this.length() != 8) {
                throw new NumberFormatException("Not a long integer");
            }
            return this.toByteBuffer().getLong();
        }

        @Override
        public String stringValue() {
            return new String(this.bytes(), StandardCharsets.UTF_8);
        }
    }

    static class ArrayCacheData
    extends CacheData {
        private final byte[] value;

        ArrayCacheData(byte[] value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length;
        }

        @Override
        boolean hasEntry() {
            return false;
        }

        @Override
        DataEntry entry() {
            throw new NoSuchElementException("This key implementation don't comes from a page.");
        }

        @Override
        public ByteIterator byteIterator() {
            return ByteIterator.of(this.value);
        }

        @Override
        public void writeTo(ByteBuffer buffer) {
            buffer.put(this.value);
        }

        @Override
        public byte[] bytes() {
            return Arrays.copyOf(this.value, this.value.length);
        }

        @Override
        public int intValue() {
            if (this.value.length != 4) {
                throw new NumberFormatException("Not an integer");
            }
            return ByteBuffer.wrap(this.value).getInt();
        }

        @Override
        public long longValue() {
            if (this.value.length != 8) {
                throw new NumberFormatException("Not a long integer");
            }
            return ByteBuffer.wrap(this.value).getLong();
        }

        @Override
        public String stringValue() {
            return new String(this.value, StandardCharsets.UTF_8);
        }
    }
}

