/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client.auth;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.http.client.RestClient;
import zeenea.connector.commons.http.client.auth.AuthHandler;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.util.Pair;
import zeenea.connector.config.ConfigPropertyKey;
import zeenea.connector.jdk.ConnectorBuilders;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.PasswordSourceConnectionConfigurationProperty;
import zeenea.connector.source.SourceStringProperty;

public class SimpleBearerAuthHandler
implements AuthHandler {
    public static final String TOKEN_KEY = "connection.token";
    public static final PasswordSourceConnectionConfigurationProperty TOKEN = ConnectorBuilders.passwordConfig((UUID)UUID.fromString("7ed1c5ab-4d74-400a-b601-e20a9ffdec7b"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"connection.token"), (String)"Authentication Token");
    @NotNull
    private final String token;

    private SimpleBearerAuthHandler(String token) {
        this.token = Objects.requireNonNull(token);
    }

    @NotNull
    public static SimpleBearerAuthHandler of(String token) {
        return new SimpleBearerAuthHandler(token);
    }

    @Nullable
    public static SimpleBearerAuthHandler of(@NotNull PropertyValueMap configuration) {
        return configuration.get((SourceStringProperty)TOKEN).map(SimpleBearerAuthHandler::of).orElse(null);
    }

    @Override
    public List<Pair<String, String>> authenticationHeaders(TracingContext ctx, RestClient client) {
        return Collections.singletonList(Pair.of((Object)"Authorization", (Object)("Bearer " + this.token)));
    }
}

