/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LakeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LAKE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lakes/{lake}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lake;

    @Deprecated
    protected LakeName() {
        this.project = null;
        this.location = null;
        this.lake = null;
    }

    private LakeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lake = (String)Preconditions.checkNotNull((Object)builder.getLake());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLake() {
        return this.lake;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LakeName of(String project, String location, String lake) {
        return LakeName.newBuilder().setProject(project).setLocation(location).setLake(lake).build();
    }

    public static String format(String project, String location, String lake) {
        return LakeName.newBuilder().setProject(project).setLocation(location).setLake(lake).build().toString();
    }

    public static LakeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LAKE.validatedMatch(formattedString, "LakeName.parse: formattedString not in valid format");
        return LakeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lake"));
    }

    public static List<LakeName> parseList(List<String> formattedStrings) {
        ArrayList<LakeName> list = new ArrayList<LakeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LakeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LakeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LakeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LAKE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LakeName lakeName = this;
            synchronized (lakeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lake != null) {
                        fieldMapBuilder.put((Object)"lake", (Object)this.lake);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LAKE.instantiate(new String[]{"project", this.project, "location", this.location, "lake", this.lake});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LakeName that = (LakeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lake, that.lake);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lake);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lake;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLake() {
            return this.lake;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLake(String lake) {
            this.lake = lake;
            return this;
        }

        private Builder(LakeName lakeName) {
            this.project = lakeName.project;
            this.location = lakeName.location;
            this.lake = lakeName.lake;
        }

        public LakeName build() {
            return new LakeName(this);
        }
    }
}

