/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import zeenea.connector.commons.cache.FilePageLoader;
import zeenea.connector.commons.cache.InvalidCacheConfigException;
import zeenea.connector.commons.cache.MemoryPageLoader;
import zeenea.connector.commons.cache.Page;

interface PageLoader
extends Closeable {
    public static PageLoader open(Path path) {
        return PageLoader.open(path, 2048, true);
    }

    public static PageLoader open(Path path, int memPageCount, boolean directAllocation) {
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new InvalidCacheConfigException("Cache file " + String.valueOf(path) + " is not a file");
            }
            if (!Files.isReadable(path)) {
                throw new InvalidCacheConfigException("Can't read cache file " + String.valueOf(path));
            }
        } else if (Files.notExists(path, new LinkOption[0])) {
            Path dir = path.toAbsolutePath().getParent();
            if (dir == null) {
                throw new InvalidCacheConfigException("File system root " + String.valueOf(path.toAbsolutePath()) + " isn't a file");
            }
            if (Files.exists(dir, new LinkOption[0])) {
                if (!Files.isDirectory(dir, new LinkOption[0])) {
                    throw new InvalidCacheConfigException("Cache file's parent " + String.valueOf(dir) + " is not a directory");
                }
                if (!Files.isReadable(dir)) {
                    throw new InvalidCacheConfigException("Can't read cache file's directory " + String.valueOf(dir));
                }
            } else {
                try {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new InvalidCacheConfigException("Can't create cache parent directories '" + String.valueOf(dir) + "': " + e.getMessage(), e);
                }
            }
        } else {
            throw new InvalidCacheConfigException("The existence of cache file " + String.valueOf(path) + " can't be detected, may be we have no access to one of it's parent folders.");
        }
        return new FilePageLoader(path, memPageCount, directAllocation);
    }

    public static PageLoader memory() {
        return PageLoader.memory(true);
    }

    public static PageLoader memory(boolean directAllocation) {
        return new MemoryPageLoader(directAllocation);
    }

    public void startLoading();

    public void stopLoading();

    public boolean readOnly();

    public boolean hasPage(int var1);

    public Page newPage();

    public Page page(int var1);

    public void release(Page var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T applyToPage(int pageNumber, Function<Page, T> function) {
        Page page = this.page(pageNumber);
        try {
            T t = function.apply(page);
            return t;
        }
        finally {
            this.release(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void consumePage(int pageNumber, Consumer<Page> consumer) {
        Page page = this.page(pageNumber);
        try {
            consumer.accept(page);
        }
        finally {
            this.release(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int applyToPageAsInt(int pageNumber, ToIntFunction<Page> function) {
        Page page = this.page(pageNumber);
        try {
            int n = function.applyAsInt(page);
            return n;
        }
        finally {
            this.release(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean testPage(int pageNumber, Predicate<Page> predicate) {
        Page page = this.page(pageNumber);
        try {
            boolean bl = predicate.test(page);
            return bl;
        }
        finally {
            this.release(page);
        }
    }

    @Override
    public void close();
}

