/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zeenea.connector.commons.cache.FilePageLoader;
import zeenea.connector.commons.cache.Page;

class FileCacheChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(FileCacheChannelHandler.class);
    private final FilePageLoader loader;
    private final Path path;
    private FileChannel channel;

    FileCacheChannelHandler(FilePageLoader loader, Path path) {
        this.loader = loader;
        this.path = path;
    }

    private FileChannel channel() {
        if (this.channel == null) {
            HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
            options.add(StandardOpenOption.READ);
            if (!this.loader.readOnly()) {
                options.add(StandardOpenOption.WRITE);
                options.add(StandardOpenOption.CREATE);
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
            }
            try {
                this.channel = FileChannel.open(this.path, options, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.channel;
    }

    int loadPageCount() {
        try {
            return Files.exists(this.path, new LinkOption[0]) ? Page.count(Files.size(this.path)) : 0;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void closeChannel() {
        if (this.channel != null) {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    void save(Page page) {
        if (!this.loader.readOnly()) {
            page.write(this.channel());
        } else {
            log.warn("Page {} modified when the page loader is in read only mode, modifications will be discarded.", (Object)page.number());
        }
    }

    void read(Page page) {
        page.read(this.channel());
    }
}

