/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.io.Closeable;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.BTreeNodePage;
import zeenea.connector.commons.cache.CachePage;
import zeenea.connector.commons.cache.DataPage;
import zeenea.connector.commons.cache.HeaderPage;
import zeenea.connector.commons.cache.InvalidPageException;
import zeenea.connector.commons.cache.Page;
import zeenea.connector.commons.cache.PageLoader;

class CachePageLoader
implements Closeable {
    private final PageLoader pageLoader;

    private CachePageLoader(PageLoader pageLoader) {
        this.pageLoader = pageLoader;
    }

    static CachePageLoader of(PageLoader pageLoader) {
        return new CachePageLoader(pageLoader);
    }

    @Override
    public void close() {
        this.pageLoader.close();
    }

    HeaderPage headerPage() {
        return HeaderPage.of(this.pageLoader);
    }

    <T extends CachePage> T page(int pageNumber, Class<T> klass) {
        return (T)this.pageLoader.applyToPage(pageNumber, page -> {
            int offset = pageNumber == 0 ? HeaderPage.HEADER_LENGTH : 0;
            byte code = page.get(offset);
            switch (code) {
                case 78: {
                    if (klass.isAssignableFrom(BTreeNodePage.class)) {
                        return (CachePage)klass.cast(BTreeNodePage.of(this, pageNumber));
                    }
                    throw new InvalidPageException("Found page " + pageNumber + " with code " + CachePage.displayCode(code) + " incompatible with " + klass.getName());
                }
                case 76: {
                    if (klass.isAssignableFrom(BTreeLeafPage.class)) {
                        return (CachePage)klass.cast(BTreeLeafPage.of(this, pageNumber, offset));
                    }
                    throw new InvalidPageException("Found page " + pageNumber + " with code " + CachePage.displayCode(code) + " incompatible with " + klass.getName());
                }
                case 68: {
                    if (!klass.isAssignableFrom(DataPage.class)) break;
                    return (CachePage)klass.cast(DataPage.of(this, pageNumber));
                }
            }
            throw new InvalidPageException(String.format("Page code %d '%s' is not valid for page %d", code, Character.valueOf((char)code), pageNumber));
        });
    }

    public BTreeNodePage newBTreeNodePage() {
        Page page = this.pageLoader.newPage();
        try {
            BTreeNodePage bTreeNodePage = BTreeNodePage.init(this, page);
            return bTreeNodePage;
        }
        finally {
            this.pageLoader.release(page);
        }
    }

    BTreeLeafPage newBTreeLeafPage() {
        Page page = this.pageLoader.newPage();
        try {
            BTreeLeafPage bTreeLeafPage = BTreeLeafPage.init(this, page, 0);
            return bTreeLeafPage;
        }
        finally {
            this.pageLoader.release(page);
        }
    }

    BTreeLeafPage initHeaderBTreeLeafPage() {
        Page page = this.pageLoader.page(0);
        try {
            BTreeLeafPage bTreeLeafPage = BTreeLeafPage.init(this, page, HeaderPage.HEADER_LENGTH);
            return bTreeLeafPage;
        }
        finally {
            this.pageLoader.release(page);
        }
    }

    DataPage newDataPage() {
        Page page = this.pageLoader.newPage();
        try {
            DataPage dataPage = DataPage.init(this, page);
            return dataPage;
        }
        finally {
            this.pageLoader.release(page);
        }
    }

    boolean hasPage(int pageNumber) {
        return this.pageLoader.hasPage(pageNumber);
    }

    void startLoading() {
        this.pageLoader.startLoading();
    }

    void stopLoading() {
        this.pageLoader.stopLoading();
    }

    PageLoader pageLoader() {
        return this.pageLoader;
    }
}

