/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.BTreeNodePointer;
import zeenea.connector.commons.cache.BTreePointer;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CachePageLoader;

final class BTreeLeafPointer
extends BTreePointer {
    private final BTreeLeafPage page;

    BTreeLeafPointer(CachePageLoader pageLoader, BTreeLeafPage page, BTreeNodePointer parent, int entryNumber) {
        super(pageLoader, parent, entryNumber);
        this.page = page;
    }

    @Override
    boolean isLeaf() {
        return true;
    }

    @Override
    BTreeLeafPointer asLeaf() {
        return this;
    }

    @Override
    BTreeNodePointer asNode() {
        throw new ClassCastException("Not a node");
    }

    @Override
    BTreeLeafPage page() {
        return this.page;
    }

    @Override
    BTreeLeafPointer findLeaf(CacheData key) {
        return this;
    }

    @Override
    BTreeLeafPointer lastLeaf() {
        return this;
    }

    @Override
    BTreeLeafPointer firstLeaf() {
        return this;
    }

    BTreeLeafPointer nextLeaf() {
        if (this.isRoot()) {
            return null;
        }
        int entryNum = this.entryNumber();
        BTreeNodePointer ancestor = this.parent();
        while (entryNum >= ancestor.page().entryCount()) {
            if (ancestor.isRoot()) {
                return null;
            }
            entryNum = ancestor.entryNumber();
            ancestor = ancestor.parent();
        }
        return ancestor.child(entryNum + 1).firstLeaf();
    }

    public String toString() {
        if (this.isRoot()) {
            return String.format("BTreeLeafPointer to %1$d (0x%1$x), no parent", this.page.pageNumber());
        }
        return String.format("BTreeLeafPointer to %1$d (0x%1$x), %2$d @ parent %3$d (0x%3$x)", this.page.pageNumber(), this.entryNumber(), this.parent().page().pageNumber());
    }
}

