package zeenea.connector.google.cloud.dataplex.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link LakeCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLakeCtx.builder()}.
 */
@Generated(from = "LakeCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLakeCtx implements LakeCtx {
  @NotNull
  private final String projectId;
  @NotNull
  private final String locationId;
  @NotNull
  private final String lakeId;

  private ImmutableLakeCtx(String projectId, String locationId, String lakeId) {
    this.projectId = projectId;
    this.locationId = locationId;
    this.lakeId = lakeId;
  }

  /**
   * @return The value of the {@code projectId} attribute
   */
  @JsonProperty("projectId")
  @NotNull
  @Override
  public String getProjectId() {
    return projectId;
  }

  /**
   * @return The value of the {@code locationId} attribute
   */
  @JsonProperty("locationId")
  @NotNull
  @Override
  public String getLocationId() {
    return locationId;
  }

  /**
   * @return The value of the {@code lakeId} attribute
   */
  @JsonProperty("lakeId")
  @NotNull
  @Override
  public String getLakeId() {
    return lakeId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LakeCtx#getProjectId() projectId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLakeCtx withProjectId(String value) {
    String newValue = Objects.requireNonNull(value, "projectId");
    if (this.projectId.equals(newValue)) return this;
    return new ImmutableLakeCtx(newValue, this.locationId, this.lakeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LakeCtx#getLocationId() locationId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locationId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLakeCtx withLocationId(String value) {
    String newValue = Objects.requireNonNull(value, "locationId");
    if (this.locationId.equals(newValue)) return this;
    return new ImmutableLakeCtx(this.projectId, newValue, this.lakeId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LakeCtx#getLakeId() lakeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lakeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLakeCtx withLakeId(String value) {
    String newValue = Objects.requireNonNull(value, "lakeId");
    if (this.lakeId.equals(newValue)) return this;
    return new ImmutableLakeCtx(this.projectId, this.locationId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLakeCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLakeCtx
        && equalTo(0, (ImmutableLakeCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableLakeCtx another) {
    return projectId.equals(another.projectId)
        && locationId.equals(another.locationId)
        && lakeId.equals(another.lakeId);
  }

  /**
   * Computes a hash code from attributes: {@code projectId}, {@code locationId}, {@code lakeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + projectId.hashCode();
    h += (h << 5) + locationId.hashCode();
    h += (h << 5) + lakeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LakeCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LakeCtx{"
        + "projectId=" + projectId
        + ", locationId=" + locationId
        + ", lakeId=" + lakeId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LakeCtx", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LakeCtx {
    @Nullable String projectId;
    @Nullable String locationId;
    @Nullable String lakeId;
    @JsonProperty("projectId")
    public void setProjectId(String projectId) {
      this.projectId = projectId;
    }
    @JsonProperty("locationId")
    public void setLocationId(String locationId) {
      this.locationId = locationId;
    }
    @JsonProperty("lakeId")
    public void setLakeId(String lakeId) {
      this.lakeId = lakeId;
    }
    @Override
    public String getProjectId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLakeId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLakeCtx fromJson(Json json) {
    ImmutableLakeCtx.Builder builder = ImmutableLakeCtx.builder();
    if (json.projectId != null) {
      builder.projectId(json.projectId);
    }
    if (json.locationId != null) {
      builder.locationId(json.locationId);
    }
    if (json.lakeId != null) {
      builder.lakeId(json.lakeId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LakeCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LakeCtx instance
   */
  public static ImmutableLakeCtx copyOf(LakeCtx instance) {
    if (instance instanceof ImmutableLakeCtx) {
      return (ImmutableLakeCtx) instance;
    }
    return ImmutableLakeCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLakeCtx ImmutableLakeCtx}.
   * <pre>
   * ImmutableLakeCtx.builder()
   *    .projectId(String) // required {@link LakeCtx#getProjectId() projectId}
   *    .locationId(String) // required {@link LakeCtx#getLocationId() locationId}
   *    .lakeId(String) // required {@link LakeCtx#getLakeId() lakeId}
   *    .build();
   * </pre>
   * @return A new ImmutableLakeCtx builder
   */
  public static ImmutableLakeCtx.Builder builder() {
    return new ImmutableLakeCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLakeCtx ImmutableLakeCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LakeCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROJECT_ID = 0x1L;
    private static final long INIT_BIT_LOCATION_ID = 0x2L;
    private static final long INIT_BIT_LAKE_ID = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String projectId;
    private @Nullable String locationId;
    private @Nullable String lakeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LakeCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LakeCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.projectId(instance.getProjectId());
      this.locationId(instance.getLocationId());
      this.lakeId(instance.getLakeId());
      return this;
    }

    /**
     * Initializes the value for the {@link LakeCtx#getProjectId() projectId} attribute.
     * @param projectId The value for projectId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("projectId")
    public final Builder projectId(String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId");
      initBits &= ~INIT_BIT_PROJECT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link LakeCtx#getLocationId() locationId} attribute.
     * @param locationId The value for locationId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locationId")
    public final Builder locationId(String locationId) {
      this.locationId = Objects.requireNonNull(locationId, "locationId");
      initBits &= ~INIT_BIT_LOCATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link LakeCtx#getLakeId() lakeId} attribute.
     * @param lakeId The value for lakeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lakeId")
    public final Builder lakeId(String lakeId) {
      this.lakeId = Objects.requireNonNull(lakeId, "lakeId");
      initBits &= ~INIT_BIT_LAKE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLakeCtx ImmutableLakeCtx}.
     * @return An immutable instance of LakeCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLakeCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLakeCtx(projectId, locationId, lakeId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT_ID) != 0) attributes.add("projectId");
      if ((initBits & INIT_BIT_LOCATION_ID) != 0) attributes.add("locationId");
      if ((initBits & INIT_BIT_LAKE_ID) != 0) attributes.add("lakeId");
      return "Cannot build LakeCtx, some of required attributes are not set " + attributes;
    }
  }
}
