package zeenea.connector.google.cloud.dataplex.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ItemRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemRef.builder()}.
 */
@Generated(from = "ItemRef", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemRef implements ItemRef {
  private final String projectId;
  private final String locationId;
  private final String lakeId;
  private final String zoneId;
  private final String entityId;

  private ImmutableItemRef(
      String projectId,
      String locationId,
      String lakeId,
      String zoneId,
      String entityId) {
    this.projectId = projectId;
    this.locationId = locationId;
    this.lakeId = lakeId;
    this.zoneId = zoneId;
    this.entityId = entityId;
  }

  /**
   * @return The value of the {@code projectId} attribute
   */
  @JsonProperty("projectId")
  @Override
  public String getProjectId() {
    return projectId;
  }

  /**
   * @return The value of the {@code locationId} attribute
   */
  @JsonProperty("locationId")
  @Override
  public String getLocationId() {
    return locationId;
  }

  /**
   * @return The value of the {@code lakeId} attribute
   */
  @JsonProperty("lakeId")
  @Override
  public String getLakeId() {
    return lakeId;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @JsonProperty("zoneId")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * @return The value of the {@code entityId} attribute
   */
  @JsonProperty("entityId")
  @Override
  public String getEntityId() {
    return entityId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getProjectId() projectId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withProjectId(String value) {
    String newValue = Objects.requireNonNull(value, "projectId");
    if (this.projectId.equals(newValue)) return this;
    return new ImmutableItemRef(newValue, this.locationId, this.lakeId, this.zoneId, this.entityId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getLocationId() locationId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locationId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withLocationId(String value) {
    String newValue = Objects.requireNonNull(value, "locationId");
    if (this.locationId.equals(newValue)) return this;
    return new ImmutableItemRef(this.projectId, newValue, this.lakeId, this.zoneId, this.entityId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getLakeId() lakeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lakeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withLakeId(String value) {
    String newValue = Objects.requireNonNull(value, "lakeId");
    if (this.lakeId.equals(newValue)) return this;
    return new ImmutableItemRef(this.projectId, this.locationId, newValue, this.zoneId, this.entityId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getZoneId() zoneId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withZoneId(String value) {
    String newValue = Objects.requireNonNull(value, "zoneId");
    if (this.zoneId.equals(newValue)) return this;
    return new ImmutableItemRef(this.projectId, this.locationId, this.lakeId, newValue, this.entityId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemRef#getEntityId() entityId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for entityId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemRef withEntityId(String value) {
    String newValue = Objects.requireNonNull(value, "entityId");
    if (this.entityId.equals(newValue)) return this;
    return new ImmutableItemRef(this.projectId, this.locationId, this.lakeId, this.zoneId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemRef
        && equalTo(0, (ImmutableItemRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemRef another) {
    return projectId.equals(another.projectId)
        && locationId.equals(another.locationId)
        && lakeId.equals(another.lakeId)
        && zoneId.equals(another.zoneId)
        && entityId.equals(another.entityId);
  }

  /**
   * Computes a hash code from attributes: {@code projectId}, {@code locationId}, {@code lakeId}, {@code zoneId}, {@code entityId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + projectId.hashCode();
    h += (h << 5) + locationId.hashCode();
    h += (h << 5) + lakeId.hashCode();
    h += (h << 5) + zoneId.hashCode();
    h += (h << 5) + entityId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ItemRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ItemRef{"
        + "projectId=" + projectId
        + ", locationId=" + locationId
        + ", lakeId=" + lakeId
        + ", zoneId=" + zoneId
        + ", entityId=" + entityId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ItemRef {
    @Nullable String projectId;
    @Nullable String locationId;
    @Nullable String lakeId;
    @Nullable String zoneId;
    @Nullable String entityId;
    @JsonProperty("projectId")
    public void setProjectId(String projectId) {
      this.projectId = projectId;
    }
    @JsonProperty("locationId")
    public void setLocationId(String locationId) {
      this.locationId = locationId;
    }
    @JsonProperty("lakeId")
    public void setLakeId(String lakeId) {
      this.lakeId = lakeId;
    }
    @JsonProperty("zoneId")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("entityId")
    public void setEntityId(String entityId) {
      this.entityId = entityId;
    }
    @Override
    public String getProjectId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getLakeId() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getEntityId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableItemRef fromJson(Json json) {
    ImmutableItemRef.Builder builder = ImmutableItemRef.builder();
    if (json.projectId != null) {
      builder.projectId(json.projectId);
    }
    if (json.locationId != null) {
      builder.locationId(json.locationId);
    }
    if (json.lakeId != null) {
      builder.lakeId(json.lakeId);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.entityId != null) {
      builder.entityId(json.entityId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ItemRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemRef instance
   */
  public static ImmutableItemRef copyOf(ItemRef instance) {
    if (instance instanceof ImmutableItemRef) {
      return (ImmutableItemRef) instance;
    }
    return ImmutableItemRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemRef ImmutableItemRef}.
   * <pre>
   * ImmutableItemRef.builder()
   *    .projectId(String) // required {@link ItemRef#getProjectId() projectId}
   *    .locationId(String) // required {@link ItemRef#getLocationId() locationId}
   *    .lakeId(String) // required {@link ItemRef#getLakeId() lakeId}
   *    .zoneId(String) // required {@link ItemRef#getZoneId() zoneId}
   *    .entityId(String) // required {@link ItemRef#getEntityId() entityId}
   *    .build();
   * </pre>
   * @return A new ImmutableItemRef builder
   */
  public static ImmutableItemRef.Builder builder() {
    return new ImmutableItemRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemRef ImmutableItemRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROJECT_ID = 0x1L;
    private static final long INIT_BIT_LOCATION_ID = 0x2L;
    private static final long INIT_BIT_LAKE_ID = 0x4L;
    private static final long INIT_BIT_ZONE_ID = 0x8L;
    private static final long INIT_BIT_ENTITY_ID = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String projectId;
    private @Nullable String locationId;
    private @Nullable String lakeId;
    private @Nullable String zoneId;
    private @Nullable String entityId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemRef instance) {
      Objects.requireNonNull(instance, "instance");
      this.projectId(instance.getProjectId());
      this.locationId(instance.getLocationId());
      this.lakeId(instance.getLakeId());
      this.zoneId(instance.getZoneId());
      this.entityId(instance.getEntityId());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getProjectId() projectId} attribute.
     * @param projectId The value for projectId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("projectId")
    public final Builder projectId(String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId");
      initBits &= ~INIT_BIT_PROJECT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getLocationId() locationId} attribute.
     * @param locationId The value for locationId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locationId")
    public final Builder locationId(String locationId) {
      this.locationId = Objects.requireNonNull(locationId, "locationId");
      initBits &= ~INIT_BIT_LOCATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getLakeId() lakeId} attribute.
     * @param lakeId The value for lakeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lakeId")
    public final Builder lakeId(String lakeId) {
      this.lakeId = Objects.requireNonNull(lakeId, "lakeId");
      initBits &= ~INIT_BIT_LAKE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("zoneId")
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemRef#getEntityId() entityId} attribute.
     * @param entityId The value for entityId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("entityId")
    public final Builder entityId(String entityId) {
      this.entityId = Objects.requireNonNull(entityId, "entityId");
      initBits &= ~INIT_BIT_ENTITY_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemRef ImmutableItemRef}.
     * @return An immutable instance of ItemRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemRef(projectId, locationId, lakeId, zoneId, entityId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT_ID) != 0) attributes.add("projectId");
      if ((initBits & INIT_BIT_LOCATION_ID) != 0) attributes.add("locationId");
      if ((initBits & INIT_BIT_LAKE_ID) != 0) attributes.add("lakeId");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      if ((initBits & INIT_BIT_ENTITY_ID) != 0) attributes.add("entityId");
      return "Cannot build ItemRef, some of required attributes are not set " + attributes;
    }
  }
}
