package zeenea.connector.google.cloud.common;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GoogleRepositoryConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGoogleRepositoryConfig.builder()}.
 */
@Generated(from = "GoogleRepositoryConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGoogleRepositoryConfig
    implements GoogleRepositoryConfig {
  private final int pageSize;
  private final int maxRetries;
  private final int searchPerMinuteQuota;
  private final int readPerMinuteQuota;
  private final int quotaTimeoutMinutes;

  private ImmutableGoogleRepositoryConfig(ImmutableGoogleRepositoryConfig.Builder builder) {
    this.readPerMinuteQuota = builder.readPerMinuteQuota;
    if (builder.pageSizeIsSet()) {
      initShim.pageSize(builder.pageSize);
    }
    if (builder.maxRetriesIsSet()) {
      initShim.maxRetries(builder.maxRetries);
    }
    if (builder.searchPerMinuteQuotaIsSet()) {
      initShim.searchPerMinuteQuota(builder.searchPerMinuteQuota);
    }
    if (builder.quotaTimeoutMinutesIsSet()) {
      initShim.quotaTimeoutMinutes(builder.quotaTimeoutMinutes);
    }
    this.pageSize = initShim.getPageSize();
    this.maxRetries = initShim.getMaxRetries();
    this.searchPerMinuteQuota = initShim.getSearchPerMinuteQuota();
    this.quotaTimeoutMinutes = initShim.quotaTimeoutMinutes();
    this.initShim = null;
  }

  private ImmutableGoogleRepositoryConfig(
      int pageSize,
      int maxRetries,
      int searchPerMinuteQuota,
      int readPerMinuteQuota,
      int quotaTimeoutMinutes) {
    this.pageSize = pageSize;
    this.maxRetries = maxRetries;
    this.searchPerMinuteQuota = searchPerMinuteQuota;
    this.readPerMinuteQuota = readPerMinuteQuota;
    this.quotaTimeoutMinutes = quotaTimeoutMinutes;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GoogleRepositoryConfig", generator = "Immutables")
  private final class InitShim {
    private byte pageSizeBuildStage = STAGE_UNINITIALIZED;
    private int pageSize;

    int getPageSize() {
      if (pageSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pageSizeBuildStage == STAGE_UNINITIALIZED) {
        pageSizeBuildStage = STAGE_INITIALIZING;
        this.pageSize = getPageSizeInitialize();
        pageSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.pageSize;
    }

    void pageSize(int pageSize) {
      this.pageSize = pageSize;
      pageSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte maxRetriesBuildStage = STAGE_UNINITIALIZED;
    private int maxRetries;

    int getMaxRetries() {
      if (maxRetriesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxRetriesBuildStage == STAGE_UNINITIALIZED) {
        maxRetriesBuildStage = STAGE_INITIALIZING;
        this.maxRetries = getMaxRetriesInitialize();
        maxRetriesBuildStage = STAGE_INITIALIZED;
      }
      return this.maxRetries;
    }

    void maxRetries(int maxRetries) {
      this.maxRetries = maxRetries;
      maxRetriesBuildStage = STAGE_INITIALIZED;
    }

    private byte searchPerMinuteQuotaBuildStage = STAGE_UNINITIALIZED;
    private int searchPerMinuteQuota;

    int getSearchPerMinuteQuota() {
      if (searchPerMinuteQuotaBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (searchPerMinuteQuotaBuildStage == STAGE_UNINITIALIZED) {
        searchPerMinuteQuotaBuildStage = STAGE_INITIALIZING;
        this.searchPerMinuteQuota = getSearchPerMinuteQuotaInitialize();
        searchPerMinuteQuotaBuildStage = STAGE_INITIALIZED;
      }
      return this.searchPerMinuteQuota;
    }

    void searchPerMinuteQuota(int searchPerMinuteQuota) {
      this.searchPerMinuteQuota = searchPerMinuteQuota;
      searchPerMinuteQuotaBuildStage = STAGE_INITIALIZED;
    }

    private byte quotaTimeoutMinutesBuildStage = STAGE_UNINITIALIZED;
    private int quotaTimeoutMinutes;

    int quotaTimeoutMinutes() {
      if (quotaTimeoutMinutesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (quotaTimeoutMinutesBuildStage == STAGE_UNINITIALIZED) {
        quotaTimeoutMinutesBuildStage = STAGE_INITIALIZING;
        this.quotaTimeoutMinutes = quotaTimeoutMinutesInitialize();
        quotaTimeoutMinutesBuildStage = STAGE_INITIALIZED;
      }
      return this.quotaTimeoutMinutes;
    }

    void quotaTimeoutMinutes(int quotaTimeoutMinutes) {
      this.quotaTimeoutMinutes = quotaTimeoutMinutes;
      quotaTimeoutMinutesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (pageSizeBuildStage == STAGE_INITIALIZING) attributes.add("pageSize");
      if (maxRetriesBuildStage == STAGE_INITIALIZING) attributes.add("maxRetries");
      if (searchPerMinuteQuotaBuildStage == STAGE_INITIALIZING) attributes.add("searchPerMinuteQuota");
      if (quotaTimeoutMinutesBuildStage == STAGE_INITIALIZING) attributes.add("quotaTimeoutMinutes");
      return "Cannot build GoogleRepositoryConfig, attribute initializers form cycle " + attributes;
    }
  }

  private int getPageSizeInitialize() {
    return GoogleRepositoryConfig.super.getPageSize();
  }

  private int getMaxRetriesInitialize() {
    return GoogleRepositoryConfig.super.getMaxRetries();
  }

  private int getSearchPerMinuteQuotaInitialize() {
    return GoogleRepositoryConfig.super.getSearchPerMinuteQuota();
  }

  private int quotaTimeoutMinutesInitialize() {
    return GoogleRepositoryConfig.super.quotaTimeoutMinutes();
  }

  /**
   * @return The value of the {@code pageSize} attribute
   */
  @Override
  public int getPageSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPageSize()
        : this.pageSize;
  }

  /**
   * @return The value of the {@code maxRetries} attribute
   */
  @Override
  public int getMaxRetries() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxRetries()
        : this.maxRetries;
  }

  /**
   * @return The value of the {@code searchPerMinuteQuota} attribute
   */
  @Override
  public int getSearchPerMinuteQuota() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSearchPerMinuteQuota()
        : this.searchPerMinuteQuota;
  }

  /**
   * @return The value of the {@code readPerMinuteQuota} attribute
   */
  @Override
  public int getReadPerMinuteQuota() {
    return readPerMinuteQuota;
  }

  /**
   * @return The value of the {@code quotaTimeoutMinutes} attribute
   */
  @Override
  public int quotaTimeoutMinutes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.quotaTimeoutMinutes()
        : this.quotaTimeoutMinutes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GoogleRepositoryConfig#getPageSize() pageSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pageSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGoogleRepositoryConfig withPageSize(int value) {
    if (this.pageSize == value) return this;
    return new ImmutableGoogleRepositoryConfig(
        value,
        this.maxRetries,
        this.searchPerMinuteQuota,
        this.readPerMinuteQuota,
        this.quotaTimeoutMinutes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GoogleRepositoryConfig#getMaxRetries() maxRetries} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxRetries
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGoogleRepositoryConfig withMaxRetries(int value) {
    if (this.maxRetries == value) return this;
    return new ImmutableGoogleRepositoryConfig(
        this.pageSize,
        value,
        this.searchPerMinuteQuota,
        this.readPerMinuteQuota,
        this.quotaTimeoutMinutes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GoogleRepositoryConfig#getSearchPerMinuteQuota() searchPerMinuteQuota} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for searchPerMinuteQuota
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGoogleRepositoryConfig withSearchPerMinuteQuota(int value) {
    if (this.searchPerMinuteQuota == value) return this;
    return new ImmutableGoogleRepositoryConfig(this.pageSize, this.maxRetries, value, this.readPerMinuteQuota, this.quotaTimeoutMinutes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GoogleRepositoryConfig#getReadPerMinuteQuota() readPerMinuteQuota} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readPerMinuteQuota
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGoogleRepositoryConfig withReadPerMinuteQuota(int value) {
    if (this.readPerMinuteQuota == value) return this;
    return new ImmutableGoogleRepositoryConfig(this.pageSize, this.maxRetries, this.searchPerMinuteQuota, value, this.quotaTimeoutMinutes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GoogleRepositoryConfig#quotaTimeoutMinutes() quotaTimeoutMinutes} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for quotaTimeoutMinutes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGoogleRepositoryConfig withQuotaTimeoutMinutes(int value) {
    if (this.quotaTimeoutMinutes == value) return this;
    return new ImmutableGoogleRepositoryConfig(this.pageSize, this.maxRetries, this.searchPerMinuteQuota, this.readPerMinuteQuota, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGoogleRepositoryConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGoogleRepositoryConfig
        && equalTo(0, (ImmutableGoogleRepositoryConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableGoogleRepositoryConfig another) {
    return pageSize == another.pageSize
        && maxRetries == another.maxRetries
        && searchPerMinuteQuota == another.searchPerMinuteQuota
        && readPerMinuteQuota == another.readPerMinuteQuota
        && quotaTimeoutMinutes == another.quotaTimeoutMinutes;
  }

  /**
   * Computes a hash code from attributes: {@code pageSize}, {@code maxRetries}, {@code searchPerMinuteQuota}, {@code readPerMinuteQuota}, {@code quotaTimeoutMinutes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pageSize;
    h += (h << 5) + maxRetries;
    h += (h << 5) + searchPerMinuteQuota;
    h += (h << 5) + readPerMinuteQuota;
    h += (h << 5) + quotaTimeoutMinutes;
    return h;
  }

  /**
   * Prints the immutable value {@code GoogleRepositoryConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GoogleRepositoryConfig{"
        + "pageSize=" + pageSize
        + ", maxRetries=" + maxRetries
        + ", searchPerMinuteQuota=" + searchPerMinuteQuota
        + ", readPerMinuteQuota=" + readPerMinuteQuota
        + ", quotaTimeoutMinutes=" + quotaTimeoutMinutes
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GoogleRepositoryConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GoogleRepositoryConfig instance
   */
  public static ImmutableGoogleRepositoryConfig copyOf(GoogleRepositoryConfig instance) {
    if (instance instanceof ImmutableGoogleRepositoryConfig) {
      return (ImmutableGoogleRepositoryConfig) instance;
    }
    return ImmutableGoogleRepositoryConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGoogleRepositoryConfig ImmutableGoogleRepositoryConfig}.
   * <pre>
   * ImmutableGoogleRepositoryConfig.builder()
   *    .pageSize(int) // optional {@link GoogleRepositoryConfig#getPageSize() pageSize}
   *    .maxRetries(int) // optional {@link GoogleRepositoryConfig#getMaxRetries() maxRetries}
   *    .searchPerMinuteQuota(int) // optional {@link GoogleRepositoryConfig#getSearchPerMinuteQuota() searchPerMinuteQuota}
   *    .readPerMinuteQuota(int) // required {@link GoogleRepositoryConfig#getReadPerMinuteQuota() readPerMinuteQuota}
   *    .quotaTimeoutMinutes(int) // optional {@link GoogleRepositoryConfig#quotaTimeoutMinutes() quotaTimeoutMinutes}
   *    .build();
   * </pre>
   * @return A new ImmutableGoogleRepositoryConfig builder
   */
  public static ImmutableGoogleRepositoryConfig.Builder builder() {
    return new ImmutableGoogleRepositoryConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGoogleRepositoryConfig ImmutableGoogleRepositoryConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GoogleRepositoryConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_READ_PER_MINUTE_QUOTA = 0x1L;
    private static final long OPT_BIT_PAGE_SIZE = 0x1L;
    private static final long OPT_BIT_MAX_RETRIES = 0x2L;
    private static final long OPT_BIT_SEARCH_PER_MINUTE_QUOTA = 0x4L;
    private static final long OPT_BIT_QUOTA_TIMEOUT_MINUTES = 0x8L;
    private long initBits = 0x1L;
    private long optBits;

    private int pageSize;
    private int maxRetries;
    private int searchPerMinuteQuota;
    private int readPerMinuteQuota;
    private int quotaTimeoutMinutes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GoogleRepositoryConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GoogleRepositoryConfig instance) {
      Objects.requireNonNull(instance, "instance");
      this.pageSize(instance.getPageSize());
      this.maxRetries(instance.getMaxRetries());
      this.searchPerMinuteQuota(instance.getSearchPerMinuteQuota());
      this.readPerMinuteQuota(instance.getReadPerMinuteQuota());
      this.quotaTimeoutMinutes(instance.quotaTimeoutMinutes());
      return this;
    }

    /**
     * Initializes the value for the {@link GoogleRepositoryConfig#getPageSize() pageSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GoogleRepositoryConfig#getPageSize() pageSize}.</em>
     * @param pageSize The value for pageSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pageSize(int pageSize) {
      this.pageSize = pageSize;
      optBits |= OPT_BIT_PAGE_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link GoogleRepositoryConfig#getMaxRetries() maxRetries} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GoogleRepositoryConfig#getMaxRetries() maxRetries}.</em>
     * @param maxRetries The value for maxRetries 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder maxRetries(int maxRetries) {
      this.maxRetries = maxRetries;
      optBits |= OPT_BIT_MAX_RETRIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GoogleRepositoryConfig#getSearchPerMinuteQuota() searchPerMinuteQuota} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GoogleRepositoryConfig#getSearchPerMinuteQuota() searchPerMinuteQuota}.</em>
     * @param searchPerMinuteQuota The value for searchPerMinuteQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder searchPerMinuteQuota(int searchPerMinuteQuota) {
      this.searchPerMinuteQuota = searchPerMinuteQuota;
      optBits |= OPT_BIT_SEARCH_PER_MINUTE_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link GoogleRepositoryConfig#getReadPerMinuteQuota() readPerMinuteQuota} attribute.
     * @param readPerMinuteQuota The value for readPerMinuteQuota 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder readPerMinuteQuota(int readPerMinuteQuota) {
      this.readPerMinuteQuota = readPerMinuteQuota;
      initBits &= ~INIT_BIT_READ_PER_MINUTE_QUOTA;
      return this;
    }

    /**
     * Initializes the value for the {@link GoogleRepositoryConfig#quotaTimeoutMinutes() quotaTimeoutMinutes} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GoogleRepositoryConfig#quotaTimeoutMinutes() quotaTimeoutMinutes}.</em>
     * @param quotaTimeoutMinutes The value for quotaTimeoutMinutes 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder quotaTimeoutMinutes(int quotaTimeoutMinutes) {
      this.quotaTimeoutMinutes = quotaTimeoutMinutes;
      optBits |= OPT_BIT_QUOTA_TIMEOUT_MINUTES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGoogleRepositoryConfig ImmutableGoogleRepositoryConfig}.
     * @return An immutable instance of GoogleRepositoryConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGoogleRepositoryConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGoogleRepositoryConfig(this);
    }

    private boolean pageSizeIsSet() {
      return (optBits & OPT_BIT_PAGE_SIZE) != 0;
    }

    private boolean maxRetriesIsSet() {
      return (optBits & OPT_BIT_MAX_RETRIES) != 0;
    }

    private boolean searchPerMinuteQuotaIsSet() {
      return (optBits & OPT_BIT_SEARCH_PER_MINUTE_QUOTA) != 0;
    }

    private boolean quotaTimeoutMinutesIsSet() {
      return (optBits & OPT_BIT_QUOTA_TIMEOUT_MINUTES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_READ_PER_MINUTE_QUOTA) != 0) attributes.add("readPerMinuteQuota");
      return "Cannot build GoogleRepositoryConfig, some of required attributes are not set " + attributes;
    }
  }
}
