/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import com.google.common.base.MoreObjects;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.checkpoint.InputStreamCheckpoint;
import io.trino.orc.stream.OrcChunkLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;

public final class OrcInputStream
extends InputStream {
    private final OrcChunkLoader chunkLoader;
    @Nullable
    private FixedLengthSliceInput current = Slices.EMPTY_SLICE.getInput();
    private long lastCheckpoint;

    public OrcInputStream(OrcChunkLoader chunkLoader) {
        this.chunkLoader = Objects.requireNonNull(chunkLoader, "chunkLoader is null");
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        if (this.current == null) {
            return 0;
        }
        return this.current.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read();
        if (result != -1) {
            return result;
        }
        this.advance();
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.current.remaining() == 0L) {
            this.advance();
            if (this.current == null) {
                return -1;
            }
        }
        return this.current.read(b, off, length);
    }

    public void skipFully(long length) throws IOException {
        while (length > 0L) {
            long result = this.skip(length);
            if (result < 0L) {
                throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Unexpected end of stream");
            }
            length -= result;
        }
    }

    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        while (offset < length) {
            int result = this.read(buffer, offset, length - offset);
            if (result < 0) {
                throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Unexpected end of stream");
            }
            offset += result;
        }
    }

    public void readFully(Slice buffer, int offset, int length) throws IOException {
        while (length > 0) {
            if (this.current != null && this.current.remaining() == 0L) {
                this.advance();
            }
            if (this.current == null) {
                throw new OrcCorruptionException(this.chunkLoader.getOrcDataSourceId(), "Unexpected end of stream");
            }
            int chunkSize = Math.min(length, (int)this.current.remaining());
            this.current.readBytes(buffer, offset, chunkSize);
            length -= chunkSize;
            offset += chunkSize;
        }
    }

    public OrcDataSourceId getOrcDataSourceId() {
        return this.chunkLoader.getOrcDataSourceId();
    }

    public long getCheckpoint() {
        long checkpoint = this.chunkLoader.getLastCheckpoint();
        if (this.current != null && this.current.position() > 0L) {
            checkpoint = InputStreamCheckpoint.createInputStreamCheckpoint(InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint), Math.toIntExact((long)InputStreamCheckpoint.decodeDecompressedOffset(checkpoint) + this.current.position()));
        }
        return checkpoint;
    }

    public void seekToCheckpoint(long checkpoint) throws IOException {
        int compressedOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        int decompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        int currentDecompressedBufferOffset = InputStreamCheckpoint.decodeDecompressedOffset(this.lastCheckpoint);
        if (this.current != null && compressedOffset == InputStreamCheckpoint.decodeCompressedBlockOffset(this.lastCheckpoint) && (long)decompressedOffset < (long)currentDecompressedBufferOffset + this.current.length()) {
            this.current.setPosition((long)(decompressedOffset - currentDecompressedBufferOffset));
            return;
        }
        this.current = Slices.EMPTY_SLICE.getInput();
        this.chunkLoader.seekToCheckpoint(checkpoint);
        this.lastCheckpoint = checkpoint;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.current == null || n <= 0L) {
            return -1L;
        }
        long result = this.current.skip(n);
        if (result != 0L) {
            return result;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.current.skip(n - 1L);
    }

    private void advance() throws IOException {
        if (!this.chunkLoader.hasNextChunk()) {
            this.current = null;
            return;
        }
        this.current = this.chunkLoader.nextChunk().getInput();
        this.lastCheckpoint = this.chunkLoader.getLastCheckpoint();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.chunkLoader).add("uncompressedOffset", this.current == null ? null : Long.valueOf(this.current.position())).toString();
    }
}

