/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.Mergeable;
import io.trino.spi.metrics.Metric;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Metrics
implements Mergeable<Metrics> {
    public static final Metrics EMPTY = new Metrics(Map.of());
    private final Map<String, Metric<?>> metrics;

    @JsonCreator
    public Metrics(Map<String, Metric<?>> metrics) {
        this.metrics = Map.copyOf(Objects.requireNonNull(metrics, "metrics is null"));
    }

    @JsonValue
    public Map<String, Metric<?>> getMetrics() {
        return this.metrics;
    }

    @Override
    public Metrics mergeWith(Metrics other) {
        return Metrics.accumulator().add(this).add(other).get();
    }

    public static Accumulator accumulator() {
        return new Accumulator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics that = (Metrics)o;
        return this.metrics.equals(that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.metrics);
    }

    public static class Accumulator {
        private final Map<String, Metric<?>> merged = new HashMap();

        private Accumulator() {
        }

        public Accumulator add(Metrics metrics) {
            metrics.getMetrics().forEach((key, value) -> this.merged.merge((String)key, (Metric<?>)value, Accumulator::merge));
            return this;
        }

        private static Metric<?> merge(Metric<?> a, Metric<?> b) {
            return a.mergeWith(b);
        }

        public Metrics get() {
            if (this.merged.isEmpty()) {
                return EMPTY;
            }
            return new Metrics(this.merged);
        }
    }
}

