/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.Objects;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import zeenea.connector.commons.http.client.ContentTypeUtil;
import zeenea.connector.commons.http.client.EntityMapper;
import zeenea.connector.commons.json.JsonMapper;
import zeenea.connector.commons.json.JsonParsingException;

public enum HttpJsonMapper implements EntityMapper
{
    INSTANCE;

    private final JsonMapper mapper = JsonMapper.of();

    public static HttpJsonMapper of() {
        return INSTANCE;
    }

    public <T> JavaType constructType(Class<T> klass) {
        return this.mapper.constructType(klass);
    }

    public <T> JavaType constructType(TypeReference<T> klass) {
        return this.mapper.constructType(klass);
    }

    @Override
    public <T> HttpEntity writeAsEntity(T content) {
        return new ByteArrayEntity(this.mapper.writeAsBytes(content), ContentType.APPLICATION_JSON);
    }

    @Override
    public <T> String prettyPrint(T o) {
        return this.mapper.prettyPrint(o);
    }

    @Override
    public <T> T readEntity(HttpEntity entity, JavaType type) throws IOException, ParseException {
        if (entity == null) {
            return null;
        }
        ContentType contentType = ContentTypeUtil.contentType(entity);
        if (Objects.equals(contentType.getMimeType(), ContentType.APPLICATION_JSON.getMimeType())) {
            String body = EntityUtils.toString((HttpEntity)entity);
            try {
                return (T)this.mapper.getMapper().readValue(body, type);
            }
            catch (JsonProcessingException e) {
                throw new JsonParsingException(String.format("Failed parsing response to '%s': '%s'", type.getTypeName(), e.getMessage()), body, (Throwable)e);
            }
        }
        throw new JsonParsingException(String.format("Content of type '%s' found, while expecting '%s'", contentType.getMimeType(), ContentType.APPLICATION_JSON.getMimeType()));
    }
}

