/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Pair<K, V> {
    private final K key;
    private final V value;

    public Pair(K key, V value) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public static <K, V> ListBuilder<K, V> listBuilder(K k, V v) {
        return new ListBuilder<K, V>().add(k, v);
    }

    public static <K, V> List<Pair<K, V>> listOf(K k, V v) {
        return new ListBuilder<K, V>().add(k, v).build();
    }

    public static <K, V> List<Pair<K, V>> listOf(K k0, V v0, K k1, V v1) {
        return new ListBuilder<K, V>().add(k0, v0).add(k1, v1).build();
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.key, pair.key) && Objects.equals(this.value, pair.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "(" + this.key + "," + this.value + ")";
    }

    public static class ListBuilder<K, V> {
        private final List<Pair<K, V>> list = new ArrayList<Pair<K, V>>();

        public ListBuilder<K, V> add(K key, V value) {
            this.list.add(Pair.of(key, value));
            return this;
        }

        public ListBuilder<K, V> add(Pair<K, V> pair) {
            this.list.add(pair);
            return this;
        }

        public List<Pair<K, V>> build() {
            return this.list;
        }
    }
}

