/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.parquet;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.Util;
import org.apache.parquet.schema.MessageType;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemFileReader;
import zeenea.connector.filesystem.schema.parquet.ParquetMetadataConverter;

public class ParquetReader {
    private static final String MAGIC_STR = "PAR1";
    private static final byte[] MAGIC = "PAR1".getBytes(StandardCharsets.US_ASCII);
    private static final String EF_MAGIC_STR = "PARE";
    private static final byte[] EC_MAGIC = "PARE".getBytes(StandardCharsets.US_ASCII);
    private static final int EPILOG_LENGTH = 8;
    private final FileSystemClient fsClient;
    private final FileSystemFile fsFile;

    public ParquetReader(FileSystemClient fileSystemClient, FileSystemFile fileSystemFile) {
        this.fsClient = fileSystemClient;
        this.fsFile = fileSystemFile;
    }

    public MessageType readParquetSchema() throws Exception {
        FileMetaData fileMetaData = this.readFileMetadata();
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        return parquetMetadataConverter.fromParquetSchema(fileMetaData.getSchema(), fileMetaData.getColumn_orders());
    }

    private FileMetaData readFileMetadata() throws Exception {
        try (FileSystemFileReader fileSystemFileReader = (FileSystemFileReader)this.fsClient.reader(this.fsFile).get();){
            Geometry geometry = this.readFileGeometry(fileSystemFileReader, this.fsFile.size());
            ByteBuffer byteBuffer = ByteBuffer.allocate(geometry.footerLength());
            fileSystemFileReader.readAt(geometry.footerOffset(), byteBuffer);
            byteBuffer.flip();
            ByteBufferInputStream byteBufferInputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{byteBuffer});
            FileMetaData fileMetaData = Util.readFileMetaData((InputStream)byteBufferInputStream, null, null);
            return fileMetaData;
        }
    }

    private Geometry readFileGeometry(FileSystemFileReader fileSystemFileReader, long l) {
        long l2 = l - 8L;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        fileSystemFileReader.readAt(l2, byteBuffer);
        byteBuffer.flip();
        int n = byteBuffer.getInt();
        byte[] byArray = new byte[MAGIC.length];
        byteBuffer.get(byArray);
        if (!Arrays.equals(byArray, MAGIC)) {
            if (Arrays.equals(byArray, EC_MAGIC)) {
                throw new IllegalArgumentException("Cannot read encrypted files");
            }
            throw new IllegalArgumentException("Invalid MAGIC value");
        }
        long l3 = l2 - (long)n;
        if (l3 < (long)MAGIC.length || l2 <= l3) {
            throw new IllegalStateException("corrupted file: Footer offset is not in the file: " + l3);
        }
        return new Geometry(l, l3, n);
    }

    private static class Geometry {
        private final long length;
        private final long footerOffset;
        private final int footerLength;

        public Geometry(long l, long l2, int n) {
            this.length = l;
            this.footerOffset = l2;
            this.footerLength = n;
        }

        public long length() {
            return this.length;
        }

        public long footerOffset() {
            return this.footerOffset;
        }

        public int footerLength() {
            return this.footerLength;
        }
    }
}

