/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.parquet;

import java.util.Iterator;
import java.util.List;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.DecimalType;
import org.apache.parquet.format.FieldRepetitionType;
import org.apache.parquet.format.IntType;
import org.apache.parquet.format.LogicalType;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.TimeType;
import org.apache.parquet.format.TimeUnit;
import org.apache.parquet.format.TimestampType;
import org.apache.parquet.format.Type;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetMetadataConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetMetadataConverter.class);

    MessageType fromParquetSchema(List<SchemaElement> list, List<org.apache.parquet.format.ColumnOrder> list2) {
        Iterator<SchemaElement> iterator = list.iterator();
        SchemaElement schemaElement = iterator.next();
        Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
        if (schemaElement.isSetField_id()) {
            messageTypeBuilder.id(schemaElement.field_id);
        }
        this.buildChildren((Types.GroupBuilder<?>)messageTypeBuilder, iterator, schemaElement.getNum_children(), list2, 0);
        return messageTypeBuilder.named(schemaElement.name);
    }

    private void buildChildren(Types.GroupBuilder<?> groupBuilder, Iterator<SchemaElement> iterator, int n, List<org.apache.parquet.format.ColumnOrder> list, int n2) {
        for (int i = 0; i < n; ++i) {
            Types.GroupBuilder groupBuilder2;
            ColumnOrder columnOrder;
            Types.PrimitiveBuilder primitiveBuilder;
            SchemaElement schemaElement = iterator.next();
            if (schemaElement.type != null) {
                primitiveBuilder = groupBuilder.primitive(this.getPrimitive(schemaElement.type), this.fromParquetRepetition(schemaElement.repetition_type));
                if (schemaElement.isSetType_length()) {
                    primitiveBuilder.length(schemaElement.type_length);
                }
                if (schemaElement.isSetPrecision()) {
                    primitiveBuilder.precision(schemaElement.precision);
                }
                if (schemaElement.isSetScale()) {
                    primitiveBuilder.scale(schemaElement.scale);
                }
                if (list != null) {
                    columnOrder = ParquetMetadataConverter.fromParquetColumnOrder(list.get(n2));
                    if (columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER && (schemaElement.type == Type.INT96 || schemaElement.converted_type == ConvertedType.INTERVAL)) {
                        columnOrder = ColumnOrder.undefined();
                    }
                    primitiveBuilder.columnOrder(columnOrder);
                }
                groupBuilder2 = primitiveBuilder;
            } else {
                groupBuilder2 = groupBuilder.group(this.fromParquetRepetition(schemaElement.repetition_type));
                this.buildChildren(groupBuilder2, iterator, schemaElement.num_children, list, n2);
            }
            if (schemaElement.isSetLogicalType()) {
                groupBuilder2.as(this.getLogicalTypeAnnotation(schemaElement.logicalType));
            }
            if (schemaElement.isSetConverted_type()) {
                primitiveBuilder = this.getLogicalTypeAnnotation(schemaElement.converted_type, schemaElement).toOriginalType();
                OriginalType originalType = columnOrder = schemaElement.isSetLogicalType() && this.getLogicalTypeAnnotation(schemaElement.logicalType) != null ? this.getLogicalTypeAnnotation(schemaElement.logicalType).toOriginalType() : null;
                if (!primitiveBuilder.equals((Object)columnOrder)) {
                    if (columnOrder != null) {
                        LOG.warn("Converted type and logical type metadata mismatch (convertedType: {}, logical type: {}). Using value in converted type.", (Object)schemaElement.converted_type, (Object)schemaElement.logicalType);
                    }
                    groupBuilder2.as((OriginalType)primitiveBuilder);
                }
            }
            if (schemaElement.isSetField_id()) {
                groupBuilder2.id(schemaElement.field_id);
            }
            groupBuilder2.named(schemaElement.name);
            ++n2;
        }
    }

    public PrimitiveType.PrimitiveTypeName getPrimitive(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown type " + String.valueOf(type));
    }

    LogicalTypeAnnotation getLogicalTypeAnnotation(ConvertedType convertedType, SchemaElement schemaElement) {
        switch (convertedType) {
            case UTF8: {
                return LogicalTypeAnnotation.stringType();
            }
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case MAP_KEY_VALUE: {
                return LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance();
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case DECIMAL: {
                int n = schemaElement == null ? 0 : schemaElement.scale;
                int n2 = schemaElement == null ? 0 : schemaElement.precision;
                return LogicalTypeAnnotation.decimalType((int)n, (int)n2);
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case TIME_MILLIS: {
                return LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
            }
            case TIME_MICROS: {
                return LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
            }
            case TIMESTAMP_MILLIS: {
                return LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
            }
            case TIMESTAMP_MICROS: {
                return LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
            }
            case INTERVAL: {
                return LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance();
            }
            case INT_8: {
                return LogicalTypeAnnotation.intType((int)8, (boolean)true);
            }
            case INT_16: {
                return LogicalTypeAnnotation.intType((int)16, (boolean)true);
            }
            case INT_32: {
                return LogicalTypeAnnotation.intType((int)32, (boolean)true);
            }
            case INT_64: {
                return LogicalTypeAnnotation.intType((int)64, (boolean)true);
            }
            case UINT_8: {
                return LogicalTypeAnnotation.intType((int)8, (boolean)false);
            }
            case UINT_16: {
                return LogicalTypeAnnotation.intType((int)16, (boolean)false);
            }
            case UINT_32: {
                return LogicalTypeAnnotation.intType((int)32, (boolean)false);
            }
            case UINT_64: {
                return LogicalTypeAnnotation.intType((int)64, (boolean)false);
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
        }
        throw new RuntimeException("Can't convert converted type to logical type, unknown converted type " + String.valueOf(convertedType));
    }

    LogicalTypeAnnotation getLogicalTypeAnnotation(LogicalType logicalType) {
        switch ((LogicalType._Fields)logicalType.getSetField()) {
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case TIME: {
                TimeType timeType = logicalType.getTIME();
                return LogicalTypeAnnotation.timeType((boolean)timeType.isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)this.convertTimeUnit(timeType.unit));
            }
            case STRING: {
                return LogicalTypeAnnotation.stringType();
            }
            case DECIMAL: {
                DecimalType decimalType = logicalType.getDECIMAL();
                return LogicalTypeAnnotation.decimalType((int)decimalType.scale, (int)decimalType.precision);
            }
            case INTEGER: {
                IntType intType = logicalType.getINTEGER();
                return LogicalTypeAnnotation.intType((int)intType.bitWidth, (boolean)intType.isSigned);
            }
            case UNKNOWN: {
                return null;
            }
            case TIMESTAMP: {
                TimestampType timestampType = logicalType.getTIMESTAMP();
                return LogicalTypeAnnotation.timestampType((boolean)timestampType.isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)this.convertTimeUnit(timestampType.unit));
            }
            case UUID: {
                return LogicalTypeAnnotation.uuidType();
            }
        }
        throw new RuntimeException("Unknown logical type " + String.valueOf(logicalType));
    }

    private LogicalTypeAnnotation.TimeUnit convertTimeUnit(TimeUnit timeUnit) {
        switch ((TimeUnit._Fields)timeUnit.getSetField()) {
            case MICROS: {
                return LogicalTypeAnnotation.TimeUnit.MICROS;
            }
            case MILLIS: {
                return LogicalTypeAnnotation.TimeUnit.MILLIS;
            }
            case NANOS: {
                return LogicalTypeAnnotation.TimeUnit.NANOS;
            }
        }
        throw new RuntimeException("Unknown time unit " + String.valueOf(timeUnit));
    }

    Type.Repetition fromParquetRepetition(FieldRepetitionType fieldRepetitionType) {
        return Type.Repetition.valueOf((String)fieldRepetitionType.name());
    }

    private static ColumnOrder fromParquetColumnOrder(org.apache.parquet.format.ColumnOrder columnOrder) {
        if (columnOrder.isSetTYPE_ORDER()) {
            return ColumnOrder.typeDefined();
        }
        return ColumnOrder.undefined();
    }
}

