/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.csv;

import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.ChainingOps$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.package;
import zeenea.connector.filesystem.schema.csv.CsvHeaderRule;
import zeenea.connector.filesystem.schema.csv.CsvHeaderRule$Always$;
import zeenea.connector.filesystem.schema.csv.CsvHeaderRule$Default$;
import zeenea.connector.filesystem.schema.csv.CsvHeaderRule$Never$;
import zeenea.connector.filesystem.schema.csv.CsvHeaderRule$OnlyString$;
import zeenea.connector.filesystem.schema.csv.CsvSchema;
import zeenea.connector.filesystem.schema.csv.CsvSchema$;
import zeenea.connector.filesystem.schema.csv.CsvSchemaExtractorConfig;
import zeenea.connector.filesystem.schema.csv.CsvSchemaReader$CsvParserIsReleasable$;
import zeenea.connector.filesystem.schema.csv.CsvValueType;
import zeenea.connector.filesystem.schema.csv.CsvValueType$;
import zeenea.connector.filesystem.schema.csv.StringCsvValueType$;
import zeenea.connector.filesystem.schema.csv.VoidCsvValueType$;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;
import zeenea.connector.source.SourceField;
import zeenea.connector.source.SourceField$;
import zeenea.connector.source.SourceItemName$;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006S\u0001!\tA\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0011\u00199\u0004\u0001)A\u0005_\u001d)\u0001\b\u0001E\u0006s\u0019)1\b\u0001E\u0005y!)\u0011F\u0002C\u00011\")\u0011L\u0002C\u00015\")\u0001\r\u0001C\u0001C\")Q\u0010\u0001C\u0001}\"9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003#\u0002A\u0011BA*\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002r\u0001!I!a\u001d\u0003\u001f\r\u001bhoU2iK6\f'+Z1eKJT!a\u0005\u000b\u0002\u0007\r\u001chO\u0003\u0002\u0016-\u000511o\u00195f[\u0006T!a\u0006\r\u0002\u0015\u0019LG.Z:zgR,WN\u0003\u0002\u001a5\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u00027\u00051!0Z3oK\u0006\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\faaY8oM&<\u0007C\u0001\u0014(\u001b\u0005\u0011\u0012B\u0001\u0015\u0013\u0005a\u00195O^*dQ\u0016l\u0017-\u0012=ue\u0006\u001cGo\u001c:D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003C\u0001\u0014\u0001\u0011\u0015!#\u00011\u0001&\u0003\u0019awnZ4feV\tq\u0006\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005)1\u000f\u001c45U*\tA'A\u0002pe\u001eL!AN\u0019\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nQcQ:w!\u0006\u00148/\u001a:JgJ+G.Z1tC\ndW\r\u0005\u0002;\r5\t\u0001AA\u000bDgZ\u0004\u0016M]:fe&\u001b(+\u001a7fCN\f'\r\\3\u0014\u0007\u0019qR\bE\u0002?\u00156s!aP$\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u001d\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002GA\u0005!Q\u000f^5m\u0013\tA\u0015*A\u0003Vg&twM\u0003\u0002GA%\u00111\n\u0014\u0002\u000b%\u0016dW-Y:bE2,'B\u0001%J!\tqe+D\u0001P\u0015\t\u0019\u0002K\u0003\u0002R%\u00069\u0001/\u0019:tKJ\u001c(BA*U\u0003%)h.\u001b<pG&$\u0018PC\u0001V\u0003\r\u0019w.\\\u0005\u0003/>\u0013\u0011bQ:w!\u0006\u00148/\u001a:\u0015\u0003e\nqA]3mK\u0006\u001cX\r\u0006\u0002\\=B\u0011q\u0004X\u0005\u0003;\u0002\u0012A!\u00168ji\")q\f\u0003a\u0001\u001b\u0006A!/Z:pkJ\u001cW-\u0001\u0006sK\u0006$7k\u00195f[\u0006$2AY5t!\r\u0019GMZ\u0007\u0002\u0013&\u0011Q-\u0013\u0002\u0004)JL\bC\u0001\u0014h\u0013\tA'CA\u0005DgZ\u001c6\r[3nC\")!.\u0003a\u0001W\u0006)\u0011N\u001c9viB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0003S>T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\nY\u0011J\u001c9viN#(/Z1n\u0011\u0015!\u0018\u00021\u0001v\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005YThBA<y!\t\t\u0005%\u0003\u0002zA\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tI\b%A\u0006iK\u0006$WM\u001d$pk:$G#B@\u0002\u0006\u0005=\u0001cA\u0010\u0002\u0002%\u0019\u00111\u0001\u0011\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0001\u0006A\u0002\u0005%\u0011A\u00025fC\u0012,'\u000fE\u0002'\u0003\u0017I1!!\u0004\u0013\u00051\u00195O\u001e,bYV,G+\u001f9f\u0011\u001d\t\tB\u0003a\u0001\u0003\u0013\t1\u0001^=q\u0003%A\u0017m\u001d%fC\u0012,'\u000fF\u0004\u0000\u0003/\tI#a\r\t\u000f\u0005e1\u00021\u0001\u0002\u001c\u00059\u0001.Z1eKJ\u001c\bCBA\u000f\u0003G\tIAD\u0002A\u0003?I1!!\t!\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\t\u00191+Z9\u000b\u0007\u0005\u0005\u0002\u0005C\u0004\u0002,-\u0001\r!!\f\u0002\u000bQL\b/Z:\u0011\u000b}\ty#a\u0007\n\u0007\u0005E\u0002E\u0001\u0004PaRLwN\u001c\u0005\u0006i.\u0001\r!^\u0001\u000fe\u0016\fGMR5sgRd\u0015N\\3t)\u0019\tI$a\u0013\u0002PA9q$a\u000f\u0002@\u0005\u001d\u0013bAA\u001fA\t1A+\u001e9mKJ\u0002RaHA\u0018\u0003\u0003\u00022aHA\"\u0013\r\t)\u0005\t\u0002\u0005\u0007\"\f'\u000f\u0005\u0004\u0002\u001e\u0005\r\u0012\u0011\n\t\u0006\u0003;\t\u0019#\u001e\u0005\u0007\u0003\u001bb\u0001\u0019A6\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006i2\u0001\r!^\u0001\u000bS:4WM\u001d+za\u0016\u001cH\u0003BA+\u0003/\u0002b!!\b\u0002$\u0005m\u0001bBA-\u001b\u0001\u0007\u0011qI\u0001\u0005e><8/\u0001\tqg\u0016,Hm\\\"pYVlgNT1nKR\u0019Q/a\u0018\t\u000f\u0005\u0005d\u00021\u0001\u0002d\u0005)\u0011N\u001c3fqB\u0019q$!\u001a\n\u0007\u0005\u001d\u0004EA\u0002J]R\f1c\u0019:fCR,\u0007k]3vI>DU-\u00193feN$B!!\u0013\u0002n!9\u0011qN\bA\u0002\u0005\r\u0014\u0001B:ju\u0016\fAb\u0019:fCR,g)[3mIN$b!!\u001e\u0002\u0004\u0006\u0015\u0005CBA\u000f\u0003G\t9\b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bG\u0001\u0007g>,(oY3\n\t\u0005\u0005\u00151\u0010\u0002\f'>,(oY3GS\u0016dG\rC\u0004\u0002\bA\u0001\r!!\u0013\t\u000f\u0005\u001d\u0005\u00031\u0001\u0002\u001c\u0005IA-\u0019;b)f\u0004Xm\u001d")
public class CsvSchemaReader {
    private volatile CsvSchemaReader$CsvParserIsReleasable$ CsvParserIsReleasable$module;
    private final CsvSchemaExtractorConfig config;
    private final Logger logger;

    private CsvSchemaReader$CsvParserIsReleasable$ CsvParserIsReleasable() {
        if (this.CsvParserIsReleasable$module == null) {
            this.CsvParserIsReleasable$lzycompute$1();
        }
        return this.CsvParserIsReleasable$module;
    }

    private Logger logger() {
        return this.logger;
    }

    public Try<CsvSchema> readSchema(InputStream input, String path) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            SeqOps seqOps;
            Seq h;
            SeqOps seqOps2;
            SeqOps seqOps3;
            Tuple2<Option<Object>, Seq<Seq<String>>> tuple2 = this.readFirstLines(input, path);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option separator = (Option)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)separator, (Object)rows);
            Option separator2 = (Option)tuple22._1();
            Seq rows2 = (Seq)tuple22._2();
            Seq<Seq<CsvValueType>> types = this.inferTypes((Seq<Seq<String>>)rows2);
            boolean bl = false;
            Vector vector = null;
            Seq<Seq<CsvValueType>> seq = types;
            if (seq instanceof Vector) {
                Seq t;
                Seq h2;
                bl = true;
                vector = (Vector)seq;
                SeqOps seqOps4 = package$.MODULE$.Vector().unapplySeq((SeqOps)vector);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) >= 0 && this.hasHeader((Seq<CsvValueType>)(h2 = (Seq)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)), (Option<Seq<CsvValueType>>)new Some((Object)(t = (Seq)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1))), path)) {
                    return new CsvSchema(this.createFields((Seq<String>)((Seq)rows2.head()), (Seq<CsvValueType>)t), (Option<Object>)separator2, true);
                }
            }
            if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Vector().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) >= 0) {
                Seq h3 = (Seq)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
                Seq t = (Seq)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
                return new CsvSchema(this.createFields(this.createPseudoHeaders(h3.size()), (Seq<CsvValueType>)t), (Option<Object>)separator2, false);
            }
            if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Vector().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && this.hasHeader((Seq<CsvValueType>)(h = (Seq)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)), (Option<Seq<CsvValueType>>)None$.MODULE$, path)) {
                return new CsvSchema((Seq<SourceField>)package$.MODULE$.Vector().empty(), (Option<Object>)separator2, true);
            }
            if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                Seq h4 = (Seq)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                return new CsvSchema(this.createFields(this.createPseudoHeaders(h4.size()), (Seq<CsvValueType>)h4), (Option<Object>)separator2, false);
            }
            return CsvSchema$.MODULE$.empty();
        });
    }

    public boolean headerFound(CsvValueType header, CsvValueType typ) {
        CsvValueType csvValueType = typ.union(header).asRequired();
        CsvValueType csvValueType2 = typ.asRequired();
        return csvValueType == null ? csvValueType2 != null : !csvValueType.equals(csvValueType2);
    }

    private boolean hasHeader(Seq<CsvValueType> headers, Option<Seq<CsvValueType>> types, String path) {
        boolean bl;
        CsvHeaderRule csvHeaderRule = this.config.header();
        if (CsvHeaderRule$Never$.MODULE$.equals(csvHeaderRule)) {
            bl = false;
        } else if (CsvHeaderRule$Default$.MODULE$.equals(csvHeaderRule)) {
            bl = types.exists((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)CsvSchemaReader.$anonfun$hasHeader$1(this, headers, t)));
        } else if (CsvHeaderRule$OnlyString$.MODULE$.equals(csvHeaderRule)) {
            bl = headers.forall((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)CsvSchemaReader.$anonfun$hasHeader$3(h)));
        } else if (CsvHeaderRule$Always$.MODULE$.equals(csvHeaderRule)) {
            bl = true;
        } else {
            throw new MatchError((Object)csvHeaderRule);
        }
        return BoxesRunTime.unboxToBoolean((Object)ChainingOps$.MODULE$.tap$extension(package.chaining$.MODULE$.scalaUtilChainingOps((Object)BoxesRunTime.boxToBoolean((boolean)bl)), (Function1 & Serializable)result -> {
            CsvSchemaReader.$anonfun$hasHeader$4(this, path, headers, types, BoxesRunTime.unboxToBoolean((Object)result));
            return BoxedUnit.UNIT;
        }));
    }

    private Tuple2<Option<Object>, Seq<Seq<String>>> readFirstLines(InputStream inputStream, String path) {
        CsvParserSettings parserSettings = new CsvParserSettings();
        parserSettings.setAutoClosingEnabled(false);
        parserSettings.detectFormatAutomatically((char[])Predef$.MODULE$.wrapString(this.config.separators()).toArray((ClassTag)ClassTag$.MODULE$.Char()));
        parserSettings.setMaxCharsPerColumn(this.config.maxCharsPerColumn());
        parserSettings.setMaxColumns(this.config.maxColumns());
        return (Tuple2)Extensions.TryExtension$.MODULE$.onFailure$extension(Extensions$.MODULE$.TryExtension(Using$.MODULE$.apply((Function0 & Serializable)() -> new CsvParser(parserSettings), (Function1 & Serializable)parser -> {
            Vector rows = CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)parser.iterate(inputStream, StandardCharsets.UTF_8).iterator()).asScala().take(1000).map((Function1 & Serializable)line -> Predef$.MODULE$.wrapRefArray((Object[])line).toVector()).toVector();
            Option separator = Option$.MODULE$.apply((Object)parser.getDetectedFormat()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)x$2.getDelimiter()));
            return new Tuple2((Object)separator, (Object)rows);
        }, (Using.Releasable)this.CsvParserIsReleasable())), (Function1 & Serializable)x0$1 -> {
            CsvSchemaReader.$anonfun$readFirstLines$5(this, path, x0$1);
            return BoxedUnit.UNIT;
        }).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)new Some((Object)BoxesRunTime.boxToCharacter((char)',')), (Object)package$.MODULE$.Vector().empty()));
    }

    private Seq<Seq<CsvValueType>> inferTypes(Seq<Seq<String>> rows) {
        Option h = rows.headOption().map((Function1 & Serializable)head -> (Seq)head.map((Function1 & Serializable)c -> CsvValueType$.MODULE$.from((String)c)));
        Vector t = rows.nonEmpty() ? (Vector)((IterableOnceOps)((IterableOps)rows.tail()).map((Function1 & Serializable)row -> (Seq)row.map((Function1 & Serializable)value -> CsvValueType$.MODULE$.from((String)value)))).foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable)(l1, l2) -> (Vector)((StrictOptimizedIterableOps)l1.zipAll((Iterable)l2, (Object)VoidCsvValueType$.MODULE$, (Object)VoidCsvValueType$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CsvValueType c1 = (CsvValueType)tuple2._1();
                CsvValueType c2 = (CsvValueType)tuple2._2();
                return c1.union(c2);
            }
            throw new MatchError((Object)tuple2);
        })) : package$.MODULE$.Vector().empty();
        return (Seq)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{h, Option$.MODULE$.when(t.nonEmpty(), (Function0 & Serializable)() -> t)}))).flatten(Predef$.MODULE$.$conforms());
    }

    private String pseudoColumnName(int index) {
        return new StringBuilder(1).append("C").append(index).toString();
    }

    private Seq<String> createPseudoHeaders(int size) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).map((Function1 & Serializable)index -> this.pseudoColumnName(BoxesRunTime.unboxToInt((Object)index)));
    }

    private Seq<SourceField> createFields(Seq<String> header, Seq<CsvValueType> dataTypes) {
        return (Seq)((IterableOps)((IterableOps)header.zip(dataTypes)).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    String fieldName = (String)tuple22._1();
                    CsvValueType vType = (CsvValueType)tuple22._2();
                    return SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply((String)Option$.MODULE$.apply((Object)fieldName).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4)))).getOrElse((Function0 & Serializable)() -> this.pseudoColumnName(index))), vType.toDataType(), vType.toNativeType(), index, SourceField$.MODULE$.useNameAsKey$default$5(), SourceField$.MODULE$.useNameAsKey$default$6(), SourceField$.MODULE$.useNameAsKey$default$7(), SourceField$.MODULE$.useNameAsKey$default$8());
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final void CsvParserIsReleasable$lzycompute$1() {
        CsvSchemaReader csvSchemaReader = this;
        synchronized (csvSchemaReader) {
            if (this.CsvParserIsReleasable$module == null) {
                this.CsvParserIsReleasable$module = new CsvSchemaReader$CsvParserIsReleasable$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasHeader$2(CsvSchemaReader $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CsvValueType h = (CsvValueType)tuple2._1();
            CsvValueType t = (CsvValueType)tuple2._2();
            return $this.headerFound(h, t);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$hasHeader$1(CsvSchemaReader $this, Seq headers$1, Seq t) {
        return ((IterableOnceOps)headers$1.zip((IterableOnce)t)).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CsvSchemaReader.$anonfun$hasHeader$2($this, x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$hasHeader$3(CsvValueType h) {
        CsvValueType csvValueType = h;
        StringCsvValueType$ stringCsvValueType$ = StringCsvValueType$.MODULE$;
        return !(csvValueType == null ? stringCsvValueType$ != null : !csvValueType.equals(stringCsvValueType$)) || h.isNullable();
    }

    public static final /* synthetic */ void $anonfun$hasHeader$4(CsvSchemaReader $this, String path$2, Seq headers$1, Option types$1, boolean result) {
        $this.logger().debug("filesystem_has_header_success file='{}' config.header='{}' headers='{}' types='{}' result='{}'", new Object[]{path$2, $this.config.header(), headers$1, types$1, BoxesRunTime.boxToBoolean((boolean)result)});
    }

    public static final /* synthetic */ boolean $anonfun$readFirstLines$6(Throwable x$3) {
        return x$3 instanceof ArrayIndexOutOfBoundsException;
    }

    public static final /* synthetic */ void $anonfun$readFirstLines$5(CsvSchemaReader $this, String path$3, Throwable x0$1) {
        boolean bl = false;
        TextParsingException textParsingException = null;
        Throwable throwable = x0$1;
        if (throwable instanceof TextParsingException) {
            bl = true;
            textParsingException = (TextParsingException)throwable;
            if (Option$.MODULE$.apply((Object)textParsingException.getCause()).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CsvSchemaReader.$anonfun$readFirstLines$6(x$3)))) {
                $this.logger().error("filesystem_csv_read_first_lines_too_much_columns_or_chars file='{}' {}", (Object)path$3, (Object)textParsingException.getCause().getMessage());
                return;
            }
        }
        if (bl) {
            $this.logger().error("filesystem_csv_read_first_lines_parsing_failed file='{}' {}", (Object)path$3, (Object)textParsingException.getMessage());
            return;
        }
        $this.logger().error("filesystem_csv_read_first_lines_failed file='{}'", (Object)path$3, (Object)throwable);
    }

    public CsvSchemaReader(CsvSchemaExtractorConfig config) {
        this.config = config;
        this.logger = LoggerFactory.getLogger(CsvSchemaReader.class);
    }
}

