/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.csv;

import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.io.CompressionUtils$;
import zeenea.connector.filesystem.schema.SchemaExtractor;
import zeenea.connector.filesystem.schema.csv.CsvSchemaExtractor$;
import zeenea.connector.filesystem.schema.csv.CsvSchemaExtractorConfig;
import zeenea.connector.filesystem.schema.csv.CsvSchemaReader;
import zeenea.connector.libs.scala.functions;
import zeenea.connector.libs.scala.functions$;
import zeenea.connector.source.SourceField;

@ScalaSignature(bytes="\u0006\u00059<Q!\u0004\b\t\u0002e1Qa\u0007\b\t\u0002qAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u00192Aa\u0007\b\u0001Q!AQ\u0006\u0002B\u0001B\u0003%a\u0006\u0003\u00052\t\t\u0005\t\u0015!\u00033\u0011\u0015\u0019C\u0001\"\u00017\u0011\u001dIDA1A\u0005\niBaa\u0011\u0003!\u0002\u0013Y\u0004b\u0002#\u0005\u0005\u0004%I!\u0012\u0005\u0007\u0013\u0012\u0001\u000b\u0011\u0002$\t\u000b)#A\u0011I&\u0002%\r\u001bhoU2iK6\fW\t\u001f;sC\u000e$xN\u001d\u0006\u0003\u001fA\t1aY:w\u0015\t\t\"#\u0001\u0004tG\",W.\u0019\u0006\u0003'Q\t!BZ5mKNL8\u000f^3n\u0015\t)b#A\u0005d_:tWm\u0019;pe*\tq#\u0001\u0004{K\u0016tW-Y\u0002\u0001!\tQ\u0012!D\u0001\u000f\u0005I\u00195O^*dQ\u0016l\u0017-\u0012=ue\u0006\u001cGo\u001c:\u0014\u0005\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00023\u0005)\u0011\r\u001d9msR\u0019q\u0005\\7\u0011\u0005i!1c\u0001\u0003\u001eSA\u0011!fK\u0007\u0002!%\u0011A\u0006\u0005\u0002\u0010'\u000eDW-\\1FqR\u0014\u0018m\u0019;pe\u000611m\u001c8gS\u001e\u0004\"AG\u0018\n\u0005Ar!\u0001G\"tmN\u001b\u0007.Z7b\u000bb$(/Y2u_J\u001cuN\u001c4jO\u0006Aam]\"mS\u0016tG\u000f\u0005\u00024i5\t!#\u0003\u00026%\t\u0001b)\u001b7f'f\u001cH/Z7DY&,g\u000e\u001e\u000b\u0004O]B\u0004\"B\u0017\b\u0001\u0004q\u0003\"B\u0019\b\u0001\u0004\u0011\u0014A\u00027pO\u001e,'/F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(A\u0003tY\u001a$$NC\u0001A\u0003\ry'oZ\u0005\u0003\u0005v\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\rg\u000eDW-\\1SK\u0006$WM]\u000b\u0002\rB\u0011!dR\u0005\u0003\u0011:\u0011qbQ:w'\u000eDW-\\1SK\u0006$WM]\u0001\u000eg\u000eDW-\\1SK\u0006$WM\u001d\u0011\u0002\u0013\u001d,GoU2iK6\fGC\u0001'h!\ri\u0005KU\u0007\u0002\u001d*\u0011qjH\u0001\u0005kRLG.\u0003\u0002R\u001d\n\u0019AK]=\u0011\u0007y\u0019V+\u0003\u0002U?\t1q\n\u001d;j_:\u00042A\u00160b\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002[1\u00051AH]8pizJ\u0011\u0001I\u0005\u0003;~\tq\u0001]1dW\u0006<W-\u0003\u0002`A\n\u00191+Z9\u000b\u0005u{\u0002C\u00012f\u001b\u0005\u0019'B\u00013\u0015\u0003\u0019\u0019x.\u001e:dK&\u0011am\u0019\u0002\f'>,(oY3GS\u0016dG\rC\u0003i\u0019\u0001\u0007\u0011.\u0001\u0004gg&#X-\u001c\t\u0003g)L!a\u001b\n\u0003\u001d\u0019KG.Z*zgR,W.\u0013;f[\")Qf\u0001a\u0001]!)\u0011g\u0001a\u0001e\u0001")
public class CsvSchemaExtractor
implements SchemaExtractor {
    private final FileSystemClient fsClient;
    private final Logger logger;
    private final CsvSchemaReader schemaReader;

    public static CsvSchemaExtractor apply(CsvSchemaExtractorConfig config, FileSystemClient fsClient) {
        return CsvSchemaExtractor$.MODULE$.apply(config, fsClient);
    }

    @Override
    public <B> Try<Option<B>> onNotEmptyFile(FileSystemItem fsItem, Function1<FileSystemFile, Try<Option<B>>> block) {
        return SchemaExtractor.onNotEmptyFile$(this, fsItem, block);
    }

    private Logger logger() {
        return this.logger;
    }

    private CsvSchemaReader schemaReader() {
        return this.schemaReader;
    }

    @Override
    public Try<Option<Seq<SourceField>>> getSchema(FileSystemItem fsItem) {
        this.logger().debug("filesystem_csv_get_schema file='{}'", (Object)fsItem.path());
        return this.onNotEmptyFile(fsItem, (Function1 & Serializable)fsFile -> functions.TryOfResourceUser$.MODULE$.use$extension(functions$.MODULE$.TryOfResourceUser($this.fsClient.inputStream((FileSystemFile)fsFile)), (Function1 & Serializable)input -> functions.TryOfResourceUser$.MODULE$.use$extension(functions$.MODULE$.TryOfResourceUser(CompressionUtils$.MODULE$.decompressStream((InputStream)input)), (Function1 & Serializable)in -> this.schemaReader().readSchema((InputStream)in, fsItem.path().toString()).map((Function1 & Serializable)fs -> {
            if (fs.fields().nonEmpty()) {
                return new Some(fs.fields());
            }
            return None$.MODULE$;
        }))));
    }

    public CsvSchemaExtractor(CsvSchemaExtractorConfig config, FileSystemClient fsClient) {
        this.fsClient = fsClient;
        SchemaExtractor.$init$(this);
        this.logger = LoggerFactory.getLogger(CsvSchemaExtractor.class);
        this.schemaReader = new CsvSchemaReader(config);
    }
}

