/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.schema.avro;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Try;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemFileReader;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.schema.SchemaExtractor;
import zeenea.connector.filesystem.schema.avro.AvroSchemaExtractor$;
import zeenea.connector.filesystem.schema.avro.FileSystemSeekableInput;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;
import zeenea.connector.source.SourceDescription$;
import zeenea.connector.source.SourceField;
import zeenea.connector.source.SourceField$;
import zeenea.connector.source.SourceItemName$;
import zeenea.connector.source.datatype.package;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019q\u0004\u0001)A\u0005k!)q\b\u0001C\u0001\u0001\")\u0011\r\u0001C\u0005E\")Q\r\u0001C\u0005M\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003_\u0001A\u0011BA\u0019\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002H\u0001!I!!\u0013\b\u000f\u000554\u0003#\u0001\u0002p\u00191!c\u0005E\u0001\u0003cBaAL\b\u0005\u0002\u0005M\u0004bBA;\u001f\u0011\u0005\u0011q\u000f\u0002\u0014\u0003Z\u0014xnU2iK6\fW\t\u001f;sC\u000e$xN\u001d\u0006\u0003)U\tA!\u0019<s_*\u0011acF\u0001\u0007g\u000eDW-\\1\u000b\u0005aI\u0012A\u00034jY\u0016\u001c\u0018p\u001d;f[*\u0011!dG\u0001\nG>tg.Z2u_JT\u0011\u0001H\u0001\u0007u\u0016,g.Z1\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0016\u0013\tASCA\bTG\",W.Y#yiJ\f7\r^8s\u0003!17o\u00117jK:$\bCA\u0016-\u001b\u00059\u0012BA\u0017\u0018\u0005A1\u0015\u000e\\3TsN$X-\\\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0003aI\u0002\"!\r\u0001\u000e\u0003MAQ!\u000b\u0002A\u0002)\nAb\u001d;sS:<7k\u00195f[\u0006,\u0012!\u000e\t\u0003mqj\u0011a\u000e\u0006\u0003)aR!!\u000f\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0014aA8sO&\u0011Qh\u000e\u0002\u0007'\u000eDW-\\1\u0002\u001bM$(/\u001b8h'\u000eDW-\\1!\u0003%9W\r^*dQ\u0016l\u0017\r\u0006\u0002B9B\u0019!)R$\u000e\u0003\rS!\u0001R\u0011\u0002\tU$\u0018\u000e\\\u0005\u0003\r\u000e\u00131\u0001\u0016:z!\r\u0001\u0003JS\u0005\u0003\u0013\u0006\u0012aa\u00149uS>t\u0007cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fv\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u0005I\u000b\u0013a\u00029bG.\fw-Z\u0005\u0003)V\u00131aU3r\u0015\t\u0011\u0016\u0005\u0005\u0002X56\t\u0001L\u0003\u0002Z3\u000511o\\;sG\u0016L!a\u0017-\u0003\u0017M{WO]2f\r&,G\u000e\u001a\u0005\u0006;\u0016\u0001\rAX\u0001\u0007MNLE/Z7\u0011\u0005-z\u0016B\u00011\u0018\u000591\u0015\u000e\\3TsN$X-\\%uK6\f\u0011#\u001a=ue\u0006\u001cGOU8piN\u001b\u0007.Z7b)\t\u0019G\rE\u0002C\u000b*CQA\u0006\u0004A\u0002U\nA\"\u001a=ue\u0006\u001cGOR5fY\u0012$raY4reV\f)\u0001C\u0003i\u000f\u0001\u0007\u0011.\u0001\u0003oC6,\u0007C\u00016o\u001d\tYG\u000e\u0005\u0002NC%\u0011Q.I\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002nC!)ac\u0002a\u0001k!)1o\u0002a\u0001i\u0006\u0019Am\\2\u0011\u0007\u0001B\u0015\u000eC\u0003w\u000f\u0001\u0007q/A\u0005oKb$\u0018J\u001c3fqB\u0019\u00010!\u0001\u000e\u0003eT!A_>\u0002\r\u0005$x.\\5d\u0015\taX0\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u0012@\u000b\u0003}\fAA[1wC&\u0019\u00111A=\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u001d\t9a\u0002a\u0001\u0003\u0013\tQB]3d_J$7/\u00138QCRD\u0007\u0003\u00026\u0002\f%L1!!\u0004q\u0005\r\u0019V\r^\u0001\u000fG\"LG\u000e\u001a:f]\u001aKW\r\u001c3t)%\u0019\u00171CA\u000b\u0003/\tI\u0002C\u0003i\u0011\u0001\u0007\u0011\u000eC\u0003\u0017\u0011\u0001\u0007Q\u0007C\u0003w\u0011\u0001\u0007q\u000fC\u0004\u0002\b!\u0001\r!!\u0003\u0002#\r\u0014X-\u0019;f'>,(oY3GS\u0016dG\rF\u0005W\u0003?\t\t#a\t\u0002.!)\u0001.\u0003a\u0001S\")a#\u0003a\u0001k!9\u0011QE\u0005A\u0002\u0005\u001d\u0012!B5oI\u0016D\bc\u0001\u0011\u0002*%\u0019\u00111F\u0011\u0003\u0007%sG\u000fC\u0003t\u0013\u0001\u0007A/\u0001\u0006jg:+H\u000e\\1cY\u0016$B!a\r\u0002:A\u0019\u0001%!\u000e\n\u0007\u0005]\u0012EA\u0004C_>dW-\u00198\t\u000bYQ\u0001\u0019A\u001b\u0002\u001b%\u001cX*\u001e7uSZ\fG.^3e)\u0011\t\u0019$a\u0010\t\u000bYY\u0001\u0019A\u001b\u0002\u00159\fG/\u001b<f)f\u0004X\rF\u0002j\u0003\u000bBQA\u0006\u0007A\u0002U\n\u0001\u0002Z1uCRK\b/\u001a\u000b\u0005\u0003\u0017\nY\u0007\u0005\u0003\u0002N\u0005\u0015d\u0002BA(\u0003CrA!!\u0015\u0002^9!\u00111KA.\u001d\u0011\t)&!\u0017\u000f\u00075\u000b9&C\u0001\u001d\u0013\tQ2$\u0003\u0002Z3%\u0019\u0011q\f-\u0002\u0011\u0011\fG/\u0019;za\u0016L1AUA2\u0015\r\ty\u0006W\u0005\u0005\u0003O\nIG\u0001\u0005ECR\fG+\u001f9f\u0015\r\u0011\u00161\r\u0005\u0006-5\u0001\r!N\u0001\u0014\u0003Z\u0014xnU2iK6\fW\t\u001f;sC\u000e$xN\u001d\t\u0003c=\u0019\"aD\u0010\u0015\u0005\u0005=\u0014!B1qa2LHc\u0001\u0019\u0002z!)\u0011&\u0005a\u0001U\u0001")
public class AvroSchemaExtractor
implements SchemaExtractor {
    private final FileSystemClient fsClient;
    private final Schema stringSchema;

    public static AvroSchemaExtractor apply(FileSystemClient fsClient) {
        return AvroSchemaExtractor$.MODULE$.apply(fsClient);
    }

    @Override
    public <B> Try<Option<B>> onNotEmptyFile(FileSystemItem fsItem, Function1<FileSystemFile, Try<Option<B>>> block) {
        return SchemaExtractor.onNotEmptyFile$(this, fsItem, block);
    }

    private Schema stringSchema() {
        return this.stringSchema;
    }

    @Override
    public Try<Option<Seq<SourceField>>> getSchema(FileSystemItem fsItem) {
        return this.onNotEmptyFile(fsItem, (Function1 & Serializable)fsFile -> $this.fsClient.reader((FileSystemFile)fsFile).map((Function1 & Serializable)reader -> {
            FileSystemSeekableInput seekableInput = new FileSystemSeekableInput(fsFile.size(), (FileSystemFileReader)reader);
            GenericDatumReader datumReader = new GenericDatumReader();
            return DataFileReader.openReader((SeekableInput)seekableInput, (DatumReader)datumReader).getSchema();
        }).flatMap((Function1 & Serializable)schema -> this.extractRootSchema((Schema)schema)).map((Function1 & Serializable)x$1 -> new Some(x$1)));
    }

    private Try<Seq<SourceField>> extractRootSchema(Schema schema) {
        AtomicInteger nextIndex = new AtomicInteger();
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            return Extensions.TraversableOnceTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.TraversableOnceTryExtension((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(schema.getFields()).asScala().toVector().map((Function1 & Serializable)f -> this.extractField(f.name(), f.schema(), (Option<String>)Option$.MODULE$.apply((Object)f.doc()), nextIndex, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{schema.getFullName()})))))), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)x$2 -> (Vector)x$2.flatten(Predef$.MODULE$.$conforms()));
        }
        if (Schema.Type.MAP.equals(type)) {
            SourceField key = SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply("[key]"), this.dataType(this.stringSchema()), this.nativeType(this.stringSchema()), nextIndex.getAndIncrement(), SourceField$.MODULE$.useNameAsKey$default$5(), SourceField$.MODULE$.useNameAsKey$default$6(), SourceField$.MODULE$.useNameAsKey$default$7(), SourceField$.MODULE$.useNameAsKey$default$8());
            return this.extractField("[value]", schema.getValueType(), (Option<String>)None$.MODULE$, nextIndex, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)value -> {
                SourceField sourceField = key;
                return (Seq)value.$plus$colon((Object)sourceField);
            });
        }
        return this.extractField("[content]", schema, (Option<String>)None$.MODULE$, nextIndex, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private Try<Seq<SourceField>> extractField(String name, Schema schema, Option<String> doc, AtomicInteger nextIndex, Set<String> recordsInPath) {
        SourceField recordField = this.createSourceField(name, schema, nextIndex.getAndIncrement(), doc);
        return this.childrenFields(name, schema, nextIndex, recordsInPath).map((Function1 & Serializable)children -> {
            SourceField sourceField = recordField;
            return (Seq)children.$plus$colon((Object)sourceField);
        });
    }

    private Try<Seq<SourceField>> childrenFields(String name, Schema schema, AtomicInteger nextIndex, Set<String> recordsInPath) {
        block5: {
            Vector vector;
            while (true) {
                Schema singleAlternative;
                SeqOps seqOps;
                SeqOps seqOps2;
                Schema.Type type;
                if (Schema.Type.RECORD.equals(type = schema.getType()) && !recordsInPath.contains((Object)schema.getFullName())) {
                    return Extensions.TraversableOnceTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.TraversableOnceTryExtension((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(schema.getFields()).asScala().toVector().map((Function1 & Serializable)f -> this.extractField(new StringBuilder(1).append(name).append("_").append(f.name()).toString(), f.schema(), (Option<String>)Option$.MODULE$.apply((Object)f.doc()), nextIndex, (Set<String>)((Set)recordsInPath.$plus((Object)schema.getFullName()))))), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)x$3 -> (Vector)x$3.flatten(Predef$.MODULE$.$conforms()));
                }
                if (Schema.Type.MAP.equals(type)) {
                    SourceField key = SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply(new StringBuilder(5).append(name).append("[key]").toString()), this.dataType(this.stringSchema()), this.nativeType(this.stringSchema()), nextIndex.getAndIncrement(), SourceField$.MODULE$.useNameAsKey$default$5(), SourceField$.MODULE$.useNameAsKey$default$6(), SourceField$.MODULE$.useNameAsKey$default$7(), SourceField$.MODULE$.useNameAsKey$default$8());
                    return this.extractField(new StringBuilder(7).append(name).append("[value]").toString(), schema.getValueType(), (Option<String>)None$.MODULE$, nextIndex, recordsInPath).map((Function1 & Serializable)value -> {
                        SourceField sourceField = key;
                        return (Seq)value.$plus$colon((Object)sourceField);
                    });
                }
                if (Schema.Type.ARRAY.equals(type)) {
                    schema = schema.getElementType();
                    continue;
                }
                if (!Schema.Type.UNION.equals(type)) break block5;
                vector = (Vector)CollectionConverters$.MODULE$.ListHasAsScala(schema.getTypes()).asScala().toVector().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaExtractor.$anonfun$childrenFields$4(s)));
                if (vector != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0) == 0) {
                    return new Success(package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$));
                }
                if (vector == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)vector)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) break;
                schema = singleAlternative = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            }
            return Extensions.TraversableOnceTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.TraversableOnceTryExtension((IterableOnce)vector.map((Function1 & Serializable)s -> this.extractField(new StringBuilder(1).append(name).append("_").append(s.getName()).toString(), (Schema)s, (Option<String>)Option$.MODULE$.apply((Object)s.getDoc()), nextIndex, recordsInPath))), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)x$4 -> (Vector)x$4.flatten(Predef$.MODULE$.$conforms()));
        }
        return new Success(package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$));
    }

    private SourceField createSourceField(String name, Schema schema, int index, Option<String> doc) {
        return SourceField$.MODULE$.useNameAsKey(SourceItemName$.MODULE$.apply(name), this.dataType(schema), this.nativeType(schema), index, this.isNullable(schema), this.isMultivalued(schema), SourceDescription$.MODULE$.from(doc.orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)schema.getDoc()))), SourceField$.MODULE$.useNameAsKey$default$8());
    }

    private boolean isNullable(Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.UNION;
        return !(type != null ? !type.equals(type2) : type2 != null) && schema.getTypes().stream().anyMatch(s -> {
            Schema.Type type = s.getType();
            Schema.Type type2 = Schema.Type.NULL;
            return !(type != null ? !type.equals(type2) : type2 != null);
        });
    }

    private boolean isMultivalued(Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.ARRAY;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private String nativeType(Schema schema) {
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type) ? true : (Schema.Type.ENUM.equals(type) ? true : Schema.Type.FIXED.equals(type))) {
            return new StringBuilder(1).append(type.getName()).append(" ").append(schema.getName()).toString();
        }
        if (Schema.Type.ARRAY.equals(type)) {
            return new StringBuilder(2).append(Schema.Type.ARRAY.getName()).append("[").append(this.nativeType(schema.getElementType())).append("]").toString();
        }
        if (Schema.Type.MAP.equals(type)) {
            return new StringBuilder(3).append(Schema.Type.MAP.getName()).append("[").append(Schema.Type.STRING.getName()).append(",").append(this.nativeType(schema.getValueType())).append("]").toString();
        }
        if (Schema.Type.UNION.equals(type)) {
            return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(schema.getTypes()).asScala().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaExtractor.$anonfun$nativeType$1(s)))).map((Function1 & Serializable)s -> this.nativeType((Schema)s))).mkString("|");
        }
        return type.getName();
    }

    private package.DataType dataType(Schema schema) {
        Schema.Type type;
        while (true) {
            if (Schema.Type.STRING.equals(type = schema.getType())) {
                return package.StringType$.MODULE$;
            }
            if (!Schema.Type.ARRAY.equals(type)) break;
            schema = schema.getElementType();
        }
        if (Schema.Type.BOOLEAN.equals(type)) {
            return package.BooleanType$.MODULE$;
        }
        if (Schema.Type.BYTES.equals(type)) {
            return package.BinaryType$.MODULE$;
        }
        if (Schema.Type.DOUBLE.equals(type)) {
            return package.DoubleType$.MODULE$;
        }
        if (Schema.Type.ENUM.equals(type)) {
            return package.StringType$.MODULE$;
        }
        if (Schema.Type.FIXED.equals(type)) {
            return package.StringType$.MODULE$;
        }
        if (Schema.Type.FLOAT.equals(type)) {
            return package.FloatType$.MODULE$;
        }
        if (Schema.Type.INT.equals(type)) {
            return package.IntegerType$.MODULE$;
        }
        if (Schema.Type.LONG.equals(type)) {
            return package.LongType$.MODULE$;
        }
        if (Schema.Type.MAP.equals(type)) {
            return package.MapType$.MODULE$;
        }
        if (Schema.Type.NULL.equals(type)) {
            return package.NullType$.MODULE$;
        }
        if (Schema.Type.RECORD.equals(type)) {
            return package.StructType$.MODULE$;
        }
        if (Schema.Type.UNION.equals(type)) {
            return package.DataType$.MODULE$.moreGenericType((Seq)CollectionConverters$.MODULE$.ListHasAsScala(schema.getTypes()).asScala().toVector().map((Function1 & Serializable)s -> this.dataType((Schema)s)), package.DataType$.MODULE$.moreGenericType$default$2());
        }
        throw new MatchError((Object)type);
    }

    public static final /* synthetic */ boolean $anonfun$childrenFields$4(Schema s) {
        Schema.Type type = s.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public static final /* synthetic */ boolean $anonfun$nativeType$1(Schema s) {
        Schema.Type type = s.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSchemaExtractor(FileSystemClient fsClient) {
        this.fsClient = fsClient;
        SchemaExtractor.$init$(this);
        this.stringSchema = (Schema)SchemaBuilder.builder().stringType();
    }
}

