/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem.inventory;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.generic.IsSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FilePath$;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.FileSystemItemExt$;
import zeenea.connector.filesystem.FileSystemKind;
import zeenea.connector.filesystem.TracingContext;
import zeenea.connector.filesystem.inventory.DatasetFound;
import zeenea.connector.filesystem.inventory.DatasetFound$;
import zeenea.connector.filesystem.inventory.DatasetFound$NotDataset$;
import zeenea.connector.filesystem.inventory.DatasetFound$Unresolved$;
import zeenea.connector.filesystem.inventory.DatasetFoundExt$;
import zeenea.connector.filesystem.inventory.DatasetFoundExt$DatasetFoundSource$;
import zeenea.connector.filesystem.inventory.DatasetRef;
import zeenea.connector.filesystem.inventory.InventoryLimits;
import zeenea.connector.filesystem.inventory.InventoryPatterns;
import zeenea.connector.filesystem.inventory.InventoryWalker;
import zeenea.connector.filesystem.inventory.StandardDatasetRef;
import zeenea.connector.filesystem.inventory.StandardMarkedDatasetRef;
import zeenea.connector.filesystem.schema.deltalake.DeltaLakeMarker;
import zeenea.connector.filesystem.schema.deltalake.DeltaLakeMarker$;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\r\u001b\u0005\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001BC\u0002\u0013%\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!b\u0001\n\u0013q\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\r\u0003!Q1A\u0005\n\u0011C\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0013\u0002\u0011\t\u0019!C\u0005\u0015\"A!\f\u0001BA\u0002\u0013%1\f\u0003\u0005b\u0001\t\u0005\t\u0015)\u0003L\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u001dY\u0007A1A\u0005\n1Da!\u001e\u0001!\u0002\u0013i\u0007b\u0002<\u0001\u0005\u0004%Ia\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003y\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e!A\u0011\u0011\u0005\u0001!B\u0013\t9\u0001C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003\u0013\u0003A\u0011BAF\u0005]\u0019F/\u00198eCJ$\u0017J\u001c<f]R|'/_,bY.,'O\u0003\u0002\u001c9\u0005I\u0011N\u001c<f]R|'/\u001f\u0006\u0003;y\t!BZ5mKNL8\u000f^3n\u0015\ty\u0002%A\u0005d_:tWm\u0019;pe*\t\u0011%\u0001\u0004{K\u0016tW-Y\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-bS\"\u0001\u000e\n\u00055R\"aD%om\u0016tGo\u001c:z/\u0006d7.\u001a:\u0002\u0007\r$\b\u0010\u0005\u00021c5\tA$\u0003\u000239\tqAK]1dS:<7i\u001c8uKb$\u0018\u0001B6j]\u0012\u0004\"\u0001M\u001b\n\u0005Yb\"A\u0004$jY\u0016\u001c\u0016p\u001d;f[.Kg\u000eZ\u0001\u0007Y&l\u0017\u000e^:\u0016\u0003e\u0002\"a\u000b\u001e\n\u0005mR\"aD%om\u0016tGo\u001c:z\u0019&l\u0017\u000e^:\u0002\u000f1LW.\u001b;tA\u0005A\u0001/\u0019;uKJt7/F\u0001@!\tY\u0003)\u0003\u0002B5\t\t\u0012J\u001c<f]R|'/\u001f)biR,'O\\:\u0002\u0013A\fG\u000f^3s]N\u0004\u0013!\u00035jKJ\f'o\u00195z+\u0005)\u0005C\u0001\u0019G\u0013\t9EDA\nGS2,7+_:uK6D\u0015.\u001a:be\u000eD\u00170\u0001\u0006iS\u0016\u0014\u0018M]2is\u0002\n!bY1oI&$\u0017\r^3t+\u0005Y\u0005c\u0001'U/:\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!\n\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005M3\u0013a\u00029bG.\fw-Z\u0005\u0003+Z\u0013aAV3di>\u0014(BA*'!\t\u0001\u0004,\u0003\u0002Z9\tqa)\u001b7f'f\u001cH/Z7Ji\u0016l\u0017AD2b]\u0012LG-\u0019;fg~#S-\u001d\u000b\u00039~\u0003\"!J/\n\u0005y3#\u0001B+oSRDq\u0001\u0019\u0006\u0002\u0002\u0003\u00071*A\u0002yIE\n1bY1oI&$\u0017\r^3tA\u00051A(\u001b8jiz\"r\u0001Z3gO\"L'\u000e\u0005\u0002,\u0001!)a\u0006\u0004a\u0001_!)1\u0007\u0004a\u0001i!)q\u0007\u0004a\u0001s!)Q\b\u0004a\u0001\u007f!)1\t\u0004a\u0001\u000b\")\u0011\n\u0004a\u0001\u0017\u00061An\\4hKJ,\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fQa\u001d7gi)T\u0011A]\u0001\u0004_J<\u0017B\u0001;p\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013a\u00043fYR\fG*Y6f\u001b\u0006\u00148.\u001a:\u0016\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0013\u0011,G\u000e^1mC.,'BA?\u001d\u0003\u0019\u00198\r[3nC&\u0011qP\u001f\u0002\u0010\t\u0016dG/\u0019'bW\u0016l\u0015M]6fe\u0006\u0001B-\u001a7uC2\u000b7.Z'be.,'\u000fI\u0001\u000eM>,h\u000e\u001a#bi\u0006\u001cX\r^:\u0016\u0005\u0005\u001d\u0001CBA\u0005\u0003'\t)\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%IW.\\;uC\ndWMC\u0002\u0002\u0012\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\r)\u00161\u0002\t\u0004W\u0005]\u0011bAA\r5\tQA)\u0019;bg\u0016$(+\u001a4\u0002#\u0019|WO\u001c3ECR\f7/\u001a;t?\u0012*\u0017\u000fF\u0002]\u0003?A\u0001\u0002\u0019\n\u0002\u0002\u0003\u0007\u0011qA\u0001\u000fM>,h\u000e\u001a#bi\u0006\u001cX\r^:!\u0003\u0011qW\r\u001f;\u0015\u0005\u0005\u001d\u0002#B\u0013\u0002*\u0005U\u0011bAA\u0016M\t1q\n\u001d;j_:D3\u0001FA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bM\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u00121\u0007\u0002\bi\u0006LGN]3d\u000351\u0018\r\\5e\u0007\"LG\u000e\u001a:f]R\u00191*a\u0010\t\u000f\u0005\u0005S\u00031\u0001\u0002D\u0005IA-\u001b:fGR|'/\u001f\t\u0004a\u0005\u0015\u0013bAA$9\t\u0019b)\u001b7f'f\u001cH/Z7ESJ,7\r^8ss\u0006AA-\u0019;bg\u0016$8\u000f\u0006\u0004\u0002N\u0005M\u0013Q\f\t\u0004W\u0005=\u0013bAA)5\taA)\u0019;bg\u0016$hi\\;oI\"9\u0011Q\u000b\fA\u0002\u0005]\u0013\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\u0011\u0007A\nI&C\u0002\u0002\\q\u0011\u0001BR5mKB\u000bG\u000f\u001b\u0005\b\u0003?2\u0002\u0019AA1\u0003!\u0019\u0007.\u001b7ee\u0016t\u0007\u0003\u0002'\u0002d]K1!!\u001aW\u0005\r\u0019V-]\u0001\u0012I\u0006$\u0018m]3ug\u001a\u0013x.\u001c$jY\u0016\u001cHCBA6\u0003w\ni\b\u0005\u0004\u0002n\u0005U\u0014Q\u0003\b\u0005\u0003_\n\t\b\u0005\u0002OM%\u0019\u00111\u000f\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\t9(!\u001f\u0003\u0007M+GOC\u0002\u0002t\u0019Bq!!\u0016\u0018\u0001\u0004\t9\u0006C\u0004\u0002\u0000]\u0001\r!!!\u0002\u0013\u0019LG.Z%uK6\u001c\b#\u0002'\u0002d\u0005\r\u0005c\u0001\u0019\u0002\u0006&\u0019\u0011q\u0011\u000f\u0003\u001d\u0019KG.Z*zgR,WNR5mK\u0006yA-\u0019;bg\u0016$hI]8n\r&dW\r\u0006\u0004\u0002\u000e\u0006U\u0015q\u0013\t\u0006K\u0005%\u0012q\u0012\t\u0004W\u0005E\u0015bAAJ5\t\u00112\u000b^1oI\u0006\u0014H\rR1uCN,GOU3g\u0011\u001d\t)\u0006\u0007a\u0001\u0003/Bq!!'\u0019\u0001\u0004\t\u0019)\u0001\u0005gS2,\u0017\n^3n\u0001")
public final class StandardInventoryWalker
implements InventoryWalker {
    private final String ctx;
    private final FileSystemKind kind;
    private final InventoryLimits limits;
    private final InventoryPatterns patterns;
    private final FileSystemHierarchy hierarchy;
    private Vector<FileSystemItem> candidates;
    private final Logger logger;
    private final DeltaLakeMarker deltaLakeMarker;
    private Vector<DatasetRef> foundDatasets;

    private InventoryLimits limits() {
        return this.limits;
    }

    private InventoryPatterns patterns() {
        return this.patterns;
    }

    private FileSystemHierarchy hierarchy() {
        return this.hierarchy;
    }

    private Vector<FileSystemItem> candidates() {
        return this.candidates;
    }

    private void candidates_$eq(Vector<FileSystemItem> x$1) {
        this.candidates = x$1;
    }

    private Logger logger() {
        return this.logger;
    }

    private DeltaLakeMarker deltaLakeMarker() {
        return this.deltaLakeMarker;
    }

    private Vector<DatasetRef> foundDatasets() {
        return this.foundDatasets;
    }

    private void foundDatasets_$eq(Vector<DatasetRef> x$1) {
        this.foundDatasets = x$1;
    }

    @Override
    public Option<DatasetRef> next() {
        block9: {
            FileSystemItem fileSystemItem;
            block10: {
                Option<StandardDatasetRef> option;
                while (true) {
                    Option option2;
                    Option option3;
                    Vector<DatasetRef> vector;
                    if ((vector = this.foundDatasets()) != null && !(option3 = package$.MODULE$.$plus$colon().unapply(vector)).isEmpty()) {
                        DatasetRef head = (DatasetRef)((Tuple2)option3.get())._1();
                        Vector tail = (Vector)((Tuple2)option3.get())._2();
                        this.foundDatasets_$eq((Vector<DatasetRef>)tail);
                        return new Some((Object)head);
                    }
                    Vector<FileSystemItem> vector2 = this.candidates();
                    if (vector2 == null || (option2 = package$.MODULE$.$plus$colon().unapply(vector2)).isEmpty()) break block9;
                    FileSystemItem head = (FileSystemItem)((Tuple2)option2.get())._1();
                    Vector tail = (Vector)((Tuple2)option2.get())._2();
                    this.candidates_$eq((Vector<FileSystemItem>)tail);
                    fileSystemItem = head;
                    if (fileSystemItem instanceof FileSystemDirectory) {
                        FileSystemDirectory fileSystemDirectory = (FileSystemDirectory)fileSystemItem;
                        if (this.deltaLakeMarker().matches(fileSystemDirectory)) {
                            return new Some((Object)new StandardMarkedDatasetRef(fileSystemDirectory.path(), this.deltaLakeMarker().format()));
                        }
                        Vector<FileSystemItem> children = this.validChildren(fileSystemDirectory);
                        DatasetFound found = this.datasets(fileSystemDirectory.path(), (Seq<FileSystemItem>)children);
                        DatasetFound datasetFound = found;
                        if (datasetFound instanceof DatasetFound.Datasets) {
                            DatasetFound.Datasets datasets = (DatasetFound.Datasets)datasetFound;
                            Set<DatasetRef> items = datasets.items();
                            this.foundDatasets_$eq((Vector<DatasetRef>)items.toVector());
                            continue;
                        }
                        if (datasetFound instanceof DatasetFound.TooMany) {
                            DatasetFound.TooMany tooMany = (DatasetFound.TooMany)datasetFound;
                            int count = tooMany.count();
                            Set<DatasetRef> sample = tooMany.sample();
                            this.logger().error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("file_system_{}_standard_inventory_walker_too_many_items_in_folder {} count='{}' max_per_folder='{}' path='{}'\n                          |    ------------------------------------------------------------------------\n                          |    Content of {} is skipped for safety reason.\n                          |    {} datasets have been found in the same directory.\n                          |    The maximum allowed per directory is {}.\n                          |    This usually happens when the files of a dataset didn't matches the\n                          |    file partition pattern.\n                          |    Either fix the inventory.file_partition_pattern parameter or\n                          |    increase the value of inventory.limits.max_items_per_folder.\n                          |    -------------------------------- sample --------------------------------\n                          |    {}\n                          |    ------------------------------------------------------------------------")), new Object[]{this.kind, new TracingContext(this.ctx), BoxesRunTime.boxToInteger((int)count), BoxesRunTime.boxToInteger((int)this.limits().maxItemsPerFolder()), fileSystemDirectory.path(), fileSystemDirectory.path(), BoxesRunTime.boxToInteger((int)count), BoxesRunTime.boxToInteger((int)this.limits().maxItemsPerFolder()), ((IterableOnceOps)sample.map((Function1 & Serializable)r -> r.sourceName())).mkString("\n    ")});
                            continue;
                        }
                        if (DatasetFound$NotDataset$.MODULE$.equals(datasetFound)) {
                            this.candidates_$eq((Vector<FileSystemItem>)((Vector)((IterableOps)FileSystemItemExt$.MODULE$.fileSystemItemSeqExt(children, IsSeq$.MODULE$.seqOpsIsSeq()).filterDirectories(BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus(this.candidates())));
                            this.foundDatasets_$eq((Vector<DatasetRef>)((Vector)this.datasetsFromFiles(fileSystemDirectory.path(), (Seq<FileSystemFile>)((Seq)FileSystemItemExt$.MODULE$.fileSystemItemSeqExt(children, IsSeq$.MODULE$.seqOpsIsSeq()).filterFiles(BuildFrom$.MODULE$.buildFromIterableOps()))).toVector().sortBy((Function1 & Serializable)x$1 -> x$1.path(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
                            continue;
                        }
                        if (DatasetFound$Unresolved$.MODULE$.equals(datasetFound)) {
                            continue;
                        }
                        throw new MatchError((Object)datasetFound);
                    }
                    if (!(fileSystemItem instanceof FileSystemFile)) break block10;
                    FileSystemFile fileSystemFile = (FileSystemFile)fileSystemItem;
                    option = this.datasetFromFile((FilePath)head.path().parent().getOrElse((Function0 & Serializable)() -> FilePath$.MODULE$.root()), fileSystemFile);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        StandardDatasetRef value = (StandardDatasetRef)some.value();
                        return new Some((Object)value);
                    }
                    if (!None$.MODULE$.equals(option)) break;
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)fileSystemItem);
        }
        return None$.MODULE$;
    }

    private Vector<FileSystemItem> validChildren(FileSystemDirectory directory) {
        return (Vector)this.hierarchy().listChildren(directory).filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)StandardInventoryWalker.$anonfun$validChildren$1(this, c)));
    }

    private DatasetFound datasets(FilePath basePath, Seq<FileSystemItem> children) {
        if (!((IterableOnceOps)FileSystemItemExt$.MODULE$.fileSystemItemSeqExt(children, IsSeq$.MODULE$.seqOpsIsSeq()).filterDirectories(BuildFrom$.MODULE$.buildFromIterableOps())).forall((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)StandardInventoryWalker.$anonfun$datasets$1(this, d)))) {
            return DatasetFound$.MODULE$.notDataset();
        }
        DatasetFound partitions = DatasetFoundExt$DatasetFoundSource$.MODULE$.findDatasets$extension(DatasetFoundExt$.MODULE$.DatasetFoundSource((IterableOnce)FileSystemItemExt$.MODULE$.fileSystemItemSeqExt(children, IsSeq$.MODULE$.seqOpsIsSeq()).filterDirectories(BuildFrom$.MODULE$.buildFromIterableOps())), (Function1 & Serializable)f -> this.datasets(basePath, (Seq<FileSystemItem>)this.validChildren((FileSystemDirectory)f)));
        return partitions.merge((Function0<DatasetFound>)(Function0 & Serializable)() -> DatasetFound$.MODULE$.datasets(this.datasetsFromFiles(basePath, (Seq<FileSystemFile>)((Seq)FileSystemItemExt$.MODULE$.fileSystemItemSeqExt(children, IsSeq$.MODULE$.seqOpsIsSeq()).filterFiles(BuildFrom$.MODULE$.buildFromIterableOps()))))).limit(this.limits().maxItemsPerFolder());
    }

    private Set<DatasetRef> datasetsFromFiles(FilePath basePath, Seq<FileSystemFile> fileItems) {
        return ((IterableOnceOps)fileItems.flatMap((Function1 & Serializable)f -> this.datasetFromFile(basePath, (FileSystemFile)f))).toSet();
    }

    private Option<StandardDatasetRef> datasetFromFile(FilePath basePath, FileSystemFile fileItem) {
        String filename = fileItem.path().name();
        return ((IterableOps)this.patterns().extensionRules().all().view().flatMap((Function1 & Serializable)rule -> {
            Matcher filenameMatcher = rule.filePattern().matcher(filename);
            if (filenameMatcher.matches()) {
                String string;
                String rawBaseName = filenameMatcher.group(1);
                Option<Pattern> option = this.patterns().filePartitions();
                if (None$.MODULE$.equals(option)) {
                    string = rawBaseName;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Pattern fp = (Pattern)some.value();
                    string = fp.matcher(rawBaseName).replaceAll("*");
                } else {
                    throw new MatchError(option);
                }
                String baseName = string;
                return new Some((Object)new StandardDatasetRef(basePath, baseName, rule.format()));
            }
            return None$.MODULE$;
        })).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$validChildren$1(StandardInventoryWalker $this, FileSystemItem c) {
        return $this.patterns().matchValidChild(c);
    }

    public static final /* synthetic */ boolean $anonfun$datasets$1(StandardInventoryWalker $this, FileSystemDirectory d) {
        return $this.patterns().matchPartition(d);
    }

    public StandardInventoryWalker(String ctx, FileSystemKind kind, InventoryLimits limits, InventoryPatterns patterns, FileSystemHierarchy hierarchy, Vector<FileSystemItem> candidates) {
        this.ctx = ctx;
        this.kind = kind;
        this.limits = limits;
        this.patterns = patterns;
        this.hierarchy = hierarchy;
        this.candidates = candidates;
        this.logger = LoggerFactory.getLogger(StandardInventoryWalker.class);
        this.deltaLakeMarker = DeltaLakeMarker$.MODULE$.apply(hierarchy);
        this.foundDatasets = (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
    }
}

