/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.ZeeCacheTableWriter;
import zeenea.connector.filesystem.DirectoryDescription;
import zeenea.connector.filesystem.FileDescription;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FilePath$;
import zeenea.connector.filesystem.FilePathDelta;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemFile;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.ItemDescription;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\u0011#\u0001%B\u0001\u0002\r\u0001\u0003\u0006\u0004%I!\r\u0005\tu\u0001\u0011\t\u0011)A\u0005e!)1\b\u0001C\u0001y!9\u0001\t\u0001a\u0001\n\u0013\t\u0005bB#\u0001\u0001\u0004%IA\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0015\u0002\"\t\u000f5\u0003!\u0019!C\u0005\u001d\"9\u00111\u0005\u0001!\u0002\u0013y\u0005bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004BB\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0001\u0002r\u0019!\u0011\f\u0001\u0003[\u0011!Y6C!b\u0001\n\u0003\t\u0005\u0002\u0003/\u0014\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011u\u001b\"Q1A\u0005\u0002yC\u0001BY\n\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006wM!\ta\u0019\u0005\bMN\u0001\r\u0011\"\u0003h\u0011\u001dq7\u00031A\u0005\n=Da!]\n!B\u0013A\u0007b\u0002:\u0014\u0005\u0004%Ia\u001d\u0005\u0007yN\u0001\u000b\u0011\u0002;\t\u000bu\u001cB\u0011\u0001@\t\u000f\u0005%1\u0003\"\u0001\u0002\f!9\u00111C\n\u0005B\u0005U!a\u0004$jY\u0016$&/Z3Ck&dG-\u001a:\u000b\u0005\r\"\u0013A\u00034jY\u0016\u001c\u0018p\u001d;f[*\u0011QEJ\u0001\nG>tg.Z2u_JT\u0011aJ\u0001\u0007u\u0016,g.Z1\u0004\u0001M\u0011\u0001A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\u000bQ\f'\r\\3\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u000b\r\f7\r[3\u000b\u0005]\"\u0013aB2p[6|gn]\u0005\u0003sQ\u00121CW3f\u0007\u0006\u001c\u0007.\u001a+bE2,wK]5uKJ\fa\u0001^1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002>\u007fA\u0011a\bA\u0007\u0002E!)\u0001g\u0001a\u0001e\u00059a.\u001a=u\u0017\u0016LX#\u0001\"\u0011\u0005-\u001a\u0015B\u0001#-\u0005\rIe\u000e^\u0001\f]\u0016DHoS3z?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u00111\u0006S\u0005\u0003\u00132\u0012A!\u00168ji\"91*BA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005Aa.\u001a=u\u0017\u0016L\b%A\u0006g_2$WM]*uC\u000e\\W#A(\u0011\u0007A+v+D\u0001R\u0015\t\u00116+\u0001\u0003vi&d'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013Q\u0001R3rk\u0016\u0004\"\u0001W\n\u000e\u0003\u0001\u0011QBR8mI\u0016\u0014()^5mI\u0016\u00148CA\n+\u0003\rYW-_\u0001\u0005W\u0016L\b%\u0001\u0003qCRDW#A0\u0011\u0005y\u0002\u0017BA1#\u0005!1\u0015\u000e\\3QCRD\u0017!\u00029bi\"\u0004CcA,eK\")1\f\u0007a\u0001\u0005\")Q\f\u0007a\u0001?\u0006ia-\u001b7f)&lWm\u001d;b[B,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003WN\u000bA\u0001^5nK&\u0011QN\u001b\u0002\b\u0013:\u001cH/\u00198u\u0003E1\u0017\u000e\\3US6,7\u000f^1na~#S-\u001d\u000b\u0003\u000fBDqa\u0013\u000e\u0002\u0002\u0003\u0007\u0001.\u0001\bgS2,G+[7fgR\fW\u000e\u001d\u0011\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012\u0001\u001e\t\u0004kj\u0014U\"\u0001<\u000b\u0005]D\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003s2\n!bY8mY\u0016\u001cG/[8o\u0013\tYhO\u0001\u0007BeJ\f\u0017PQ;jY\u0012,'/A\u0005dQ&dGM]3oA\u0005A\u0011\r\u001a3DQ&dG\r\u0006\u0002H\u007f\"9\u0011\u0011\u0001\u0010A\u0002\u0005\r\u0011\u0001B5uK6\u00042APA\u0003\u0013\r\t9A\t\u0002\u000f\r&dWmU=ti\u0016l\u0017\n^3n\u0003\u0015\u0011W/\u001b7e)\t\ti\u0001E\u0002?\u0003\u001fI1!!\u0005#\u0005M1\u0015\u000e\\3TsN$X-\u001c#je\u0016\u001cGo\u001c:z\u0003!!xn\u0015;sS:<GCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f'\u0006!A.\u00198h\u0013\u0011\t\t#a\u0007\u0003\rM#(/\u001b8h\u000311w\u000e\u001c3feN#\u0018mY6!\u0003\r\tG\r\u001a\u000b\u0004\u000f\u0006%\u0002bBA\u0016\u0013\u0001\u0007\u0011QF\u0001\b]\u0016<\u0018\n^3n!\rq\u0014qF\u0005\u0004\u0003c\u0011#aD%uK6$Um]2sSB$\u0018n\u001c8\u0002\u000f\u0005$GMR5mKR\u0019q)a\u000e\t\u000f\u0005e\"\u00021\u0001\u0002<\u00059a.Z<GS2,\u0007c\u0001 \u0002>%\u0019\u0011q\b\u0012\u0003\u001f\u0019KG.\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\fA\"\u00193e\t&\u0014Xm\u0019;pef$2aRA#\u0011\u001d\t9e\u0003a\u0001\u0003\u0013\nAB\\3x\t&\u0014Xm\u0019;pef\u00042APA&\u0013\r\tiE\t\u0002\u0015\t&\u0014Xm\u0019;pef$Um]2sSB$\u0018n\u001c8\u0002\u001dU\u0004xM]1eK\u001a{G\u000eZ3sgR\u0019q)a\u0015\t\u000f\u0005UC\u00021\u0001\u0002X\u0005)A-\u001a7uCB\u0019a(!\u0017\n\u0007\u0005m#EA\u0007GS2,\u0007+\u0019;i\t\u0016dG/Y\u0001\u000eGV\u0014(/\u001a8u\r>dG-\u001a:\u0016\u0003]\u000baA\\3x\u0017\u0016LH#\u0001\"\u0002\u0015=\u0004XM\u001c$pY\u0012,'\u000fF\u0002H\u0003SBQ!X\bA\u0002}#2aRA7\u0011\u001d\t\t\u0001\u0005a\u0001\u0003\u0007\t!c\u00197pg\u0016\u001cUO\u001d:f]R4u\u000e\u001c3feR\tq)\u0001\u0003e_:,\u0007")
public class FileTreeBuilder {
    private final ZeeCacheTableWriter table;
    private int nextKey;
    private final Deque<FolderBuilder> folderStack;

    private ZeeCacheTableWriter table() {
        return this.table;
    }

    private int nextKey() {
        return this.nextKey;
    }

    private void nextKey_$eq(int x$1) {
        this.nextKey = x$1;
    }

    private Deque<FolderBuilder> folderStack() {
        return this.folderStack;
    }

    public void add(ItemDescription newItem) {
        ItemDescription itemDescription = newItem;
        if (itemDescription instanceof FileDescription) {
            FileDescription fileDescription = (FileDescription)itemDescription;
            this.addFile(fileDescription);
            return;
        }
        if (itemDescription instanceof DirectoryDescription) {
            DirectoryDescription directoryDescription = (DirectoryDescription)itemDescription;
            this.addDirectory(directoryDescription);
            return;
        }
        throw new MatchError((Object)itemDescription);
    }

    public void addFile(FileDescription newFile) {
        FilePathDelta delta = this.currentFolder().path().delta(newFile.path());
        this.upgradeFolders(delta);
        FileSystemFile fsFile = new FileSystemFile(this.newKey(), newFile.path(), newFile.lastModified(), newFile.size());
        this.cache(fsFile);
        this.currentFolder().addChild(fsFile);
    }

    public void addDirectory(DirectoryDescription newDirectory) {
        FilePathDelta delta = this.currentFolder().path().delta(newDirectory.path());
        if (!delta.same()) {
            this.upgradeFolders(delta);
            this.openFolder(newDirectory.path());
            return;
        }
    }

    private void upgradeFolders(FilePathDelta delta) {
        int oldFolderLength = delta.oldPath().length();
        int prefixLength = delta.prefixLength();
        FilePath newPath = delta.newPath();
        int newFolderLength = newPath.length() - 1;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(prefixLength), oldFolderLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int n = x$1;
            this.closeCurrentFolder();
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(prefixLength + 1), newFolderLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.openFolder(newPath.prefix(i)));
    }

    private FolderBuilder currentFolder() {
        return this.folderStack().element();
    }

    private int newKey() {
        int key = this.nextKey();
        this.nextKey_$eq(this.nextKey() + 1);
        return key;
    }

    private void openFolder(FilePath path) {
        this.folderStack().push(new FolderBuilder(this, this.newKey(), path));
    }

    private void cache(FileSystemItem item) {
        this.table().add(CacheData.of((int)item.cacheKey()), item.toCacheValue());
    }

    private void closeCurrentFolder() {
        FolderBuilder folderBuilder = this.folderStack().pop();
        FileSystemDirectory closedFolder = folderBuilder.build();
        FolderBuilder parent = this.currentFolder();
        this.cache(closedFolder);
        parent.addChild(closedFolder);
    }

    public void done() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.folderStack().size() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            int n = x$2;
            this.closeCurrentFolder();
        });
        FolderBuilder folderBuilder = this.folderStack().pop();
        FileSystemDirectory closedFolder = folderBuilder.build();
        this.cache(closedFolder);
    }

    /*
     * WARNING - void declaration
     */
    public FileTreeBuilder(ZeeCacheTableWriter table) {
        void var2_2;
        this.table = table;
        this.nextKey = 1;
        ArrayDeque<FolderBuilder> folderStack = new ArrayDeque<FolderBuilder>();
        folderStack.push(new FolderBuilder(this, 0, FilePath$.MODULE$.root()));
        this.folderStack = var2_2;
    }

    private class FolderBuilder {
        private final int key;
        private final FilePath path;
        private Instant fileTimestamp;
        private final ArrayBuilder<Object> children;
        public final /* synthetic */ FileTreeBuilder $outer;

        public int key() {
            return this.key;
        }

        public FilePath path() {
            return this.path;
        }

        private Instant fileTimestamp() {
            return this.fileTimestamp;
        }

        private void fileTimestamp_$eq(Instant x$1) {
            this.fileTimestamp = x$1;
        }

        private ArrayBuilder<Object> children() {
            return this.children;
        }

        public void addChild(FileSystemItem item) {
            this.children().$plus$eq((Object)BoxesRunTime.boxToInteger((int)item.cacheKey()));
            Instant childTimestamp = item.timestamp();
            if (this.fileTimestamp().isBefore(childTimestamp)) {
                this.fileTimestamp_$eq(childTimestamp);
                return;
            }
        }

        public FileSystemDirectory build() {
            return new FileSystemDirectory(this.key(), this.path(), this.fileTimestamp(), (int[])this.children().result());
        }

        public String toString() {
            return new StringBuilder(30).append("FolderBuilder(path='").append(this.path()).append("', key='").append(this.key()).append("')").toString();
        }

        public /* synthetic */ FileTreeBuilder zeenea$connector$filesystem$FileTreeBuilder$FolderBuilder$$$outer() {
            return this.$outer;
        }

        public FolderBuilder(FileTreeBuilder $outer, int key, FilePath path) {
            this.key = key;
            this.path = path;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.fileTimestamp = Instant.EPOCH;
            this.children = Array$.MODULE$.newBuilder((ClassTag)ClassTag$.MODULE$.Int());
        }
    }
}

