/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.util.concurrent.ThreadLocalRandom;

public final class SpanId
implements Comparable<SpanId> {
    private static final int SPAN_ID_STRING_LENGTH = 32;
    private final long high;
    private final long low;
    public static SpanId INVALID = new SpanId(0L, 0L);

    private static long nonZeroRand64() {
        long l;
        while ((l = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return l;
    }

    public static SpanId fromRandom() {
        return new SpanId(SpanId.nonZeroRand64(), SpanId.nonZeroRand64());
    }

    public static SpanId fromString(String string) {
        if (string.length() != 32) {
            throw new RuntimeException("Invalid SpanID string: length was not 32");
        }
        long l = Long.parseLong(string.substring(0, 8), 16) << 32 | Long.parseLong(string.substring(8, 16), 16);
        long l2 = Long.parseLong(string.substring(16, 24), 16) << 32 | Long.parseLong(string.substring(24, 32), 16);
        return new SpanId(l, l2);
    }

    public SpanId(long l, long l2) {
        this.high = l;
        this.low = l2;
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpanId)) {
            return false;
        }
        SpanId spanId = (SpanId)object;
        return spanId.high == this.high && spanId.low == this.low;
    }

    @Override
    public int compareTo(SpanId spanId) {
        int n = SpanId.compareAsUnsigned(this.high, spanId.high);
        if (n != 0) {
            return n;
        }
        return SpanId.compareAsUnsigned(this.low, spanId.low);
    }

    private static int compareAsUnsigned(long l, long l2) {
        boolean bl;
        boolean bl2 = l < 0L;
        boolean bl3 = bl = l2 < 0L;
        if (bl2 != bl) {
            if (bl2) {
                return 1;
            }
            return -1;
        }
        if (bl2) {
            l = -l;
            l2 = -l2;
        }
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(0xFFFFFFFFFFFFFFFFL & this.high >> 32) ^ (int)(0xFFFFFFFFFFFFFFFFL & this.high >> 0) ^ (int)(0xFFFFFFFFFFFFFFFFL & this.low >> 32) ^ (int)(0xFFFFFFFFFFFFFFFFL & this.low >> 0);
    }

    public String toString() {
        return String.format("%08x%08x%08x%08x", 0xFFFFFFFFL & this.high >> 32, 0xFFFFFFFFL & this.high, 0xFFFFFFFFL & this.low >> 32, 0xFFFFFFFFL & this.low);
    }

    public boolean isValid() {
        return this.high != 0L || this.low != 0L;
    }

    public SpanId newChildId() {
        return new SpanId(this.high, SpanId.nonZeroRand64());
    }
}

