/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import zeenea.connector.commons.cache.CacheAddress;

public class VarInt
extends Number {
    private final long value;

    VarInt(long value) {
        this.value = value;
    }

    public static VarInt of(long value) {
        return new VarInt(value);
    }

    public static VarInt read(ByteBuffer buffer, int index) {
        long value = 0L;
        boolean more = true;
        for (int i = 0; more && i < 8; ++i) {
            byte b = buffer.get(index + i);
            value <<= 7;
            value |= (long)b & 0x7FL;
            more = (b & 0x80) != 0;
        }
        if (more) {
            byte b = buffer.get(index + 8);
            value <<= 8;
            value |= (long)b & 0xFFL;
        }
        return new VarInt(value);
    }

    public void writeTo(ByteBuffer bb, int index) {
        int len = this.length();
        int extra = len == 9 ? 1 : 0;
        for (int i = 0; i < len - 1; ++i) {
            int delta = (len - i - 1) * 7 + extra;
            byte b = (byte)(this.value >>> delta & 0x7FL | 0x80L);
            bb.put(index + i, b);
        }
        byte b = (byte)(this.value & (long)(len == 9 ? 255 : 127));
        bb.put(index + len - 1, b);
    }

    public void writeTo(ByteBuffer bb) {
        int len = this.length();
        int extra = len == 9 ? 1 : 0;
        for (int i = 0; i < len - 1; ++i) {
            int delta = (len - i - 1) * 7 + extra;
            byte b = (byte)(this.value >>> delta & 0x7FL | 0x80L);
            bb.put(b);
        }
        byte b = (byte)(this.value & (long)(len == 9 ? 255 : 127));
        bb.put(b);
    }

    public CacheAddress cacheAddressValue() {
        return CacheAddress.of((int)(this.value >>> 16), (short)this.value);
    }

    public int length() {
        int digitsCount = 64 - Long.numberOfLeadingZeros(this.value);
        switch (digitsCount) {
            case 0: {
                return 1;
            }
            case 64: {
                return 9;
            }
        }
        return (digitsCount + 6) / 7;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

