/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.Objects;
import zeenea.connector.commons.cache.BTreeLeafEntry;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.CacheData;

public class CacheEntry {
    private final CacheData key;
    private final CacheData value;

    private CacheEntry(CacheData key, CacheData value) {
        this.key = key;
        this.value = value;
    }

    public static CacheEntry of(CacheData key, CacheData value) {
        return new CacheEntry(key, value);
    }

    public static CacheEntry of(BTreeLeafPage page, BTreeLeafEntry leafEntry) {
        return new CacheEntry(CacheData.of(page, leafEntry.keyEntry()), CacheData.of(page, leafEntry.valueEntry()));
    }

    public CacheData key() {
        return this.key;
    }

    public CacheData value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntry entry = (CacheEntry)o;
        return Objects.equals(this.key, entry.key) && Objects.equals(this.value, entry.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + " -> " + this.value;
    }
}

