/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.NoSuchElementException;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.BTreeLeafPointer;
import zeenea.connector.commons.cache.BTreeNodePage;
import zeenea.connector.commons.cache.BTreeNodePointer;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CachePageLoader;

abstract class BTreePointer {
    protected final CachePageLoader pageLoader;
    private final BTreeNodePointer parent;
    private final int entryNumber;

    protected BTreePointer(CachePageLoader pageLoader, BTreeNodePointer parent, int entryNumber) {
        this.pageLoader = pageLoader;
        this.parent = parent;
        this.entryNumber = entryNumber;
    }

    static BTreePointer of(BTreePage root) {
        if (root instanceof BTreeNodePage) {
            return new BTreeNodePointer(root.pageLoader(), (BTreeNodePage)root, null, 0);
        }
        return new BTreeLeafPointer(root.pageLoader(), (BTreeLeafPage)root, null, 0);
    }

    static BTreeNodePointer of(BTreeNodePage root) {
        return new BTreeNodePointer(root.pageLoader(), root, null, 0);
    }

    static BTreeLeafPointer of(BTreeLeafPage root) {
        return new BTreeLeafPointer(root.pageLoader(), root, null, 0);
    }

    abstract boolean isLeaf();

    boolean isRoot() {
        return this.parent == null;
    }

    abstract BTreePage page();

    BTreeNodePointer parent() {
        if (this.isRoot()) {
            throw new NoSuchElementException("Root node has no parent");
        }
        return this.parent;
    }

    public int entryNumber() {
        return this.entryNumber;
    }

    abstract BTreeLeafPointer asLeaf();

    abstract BTreeNodePointer asNode();

    abstract BTreeLeafPointer findLeaf(CacheData var1);

    abstract BTreeLeafPointer lastLeaf();

    abstract BTreeLeafPointer firstLeaf();
}

