/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.net.UrlEscapers;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Any;
import io.grpc.Status;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Locality;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.XdsResourceType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

abstract class XdsClient {
    XdsClient() {
    }

    static boolean isResourceNameValid(String resourceName, String typeUrl) {
        URI uri;
        Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
        if (!resourceName.startsWith("xdstp:")) {
            return true;
        }
        try {
            uri = new URI(resourceName);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String path = uri.getPath();
        Splitter slashSplitter = Splitter.on((char)'/').omitEmptyStrings();
        if (path == null) {
            return false;
        }
        List pathSegs = slashSplitter.splitToList((CharSequence)path);
        if (pathSegs.size() < 2) {
            return false;
        }
        String type = (String)pathSegs.get(0);
        return type.equals(slashSplitter.splitToList((CharSequence)typeUrl).get(1));
    }

    static String canonifyResourceName(String resourceName) {
        Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
        if (!resourceName.startsWith("xdstp:")) {
            return resourceName;
        }
        URI uri = URI.create(resourceName);
        String rawQuery = uri.getRawQuery();
        Splitter ampSplitter = Splitter.on((char)'&').omitEmptyStrings();
        if (rawQuery == null) {
            return resourceName;
        }
        List queries = ampSplitter.splitToList((CharSequence)rawQuery);
        if (queries.size() < 2) {
            return resourceName;
        }
        ArrayList<String> canonicalContextParams = new ArrayList<String>(queries.size());
        for (String query : queries) {
            canonicalContextParams.add(query);
        }
        Collections.sort(canonicalContextParams);
        String canonifiedQuery = Joiner.on((char)'&').join(canonicalContextParams);
        return resourceName.replace(rawQuery, canonifiedQuery);
    }

    static String percentEncodePath(String input) {
        Iterable pathSegs = Splitter.on((char)'/').split((CharSequence)input);
        ArrayList<String> encodedSegs = new ArrayList<String>();
        for (String pathSeg : pathSegs) {
            encodedSegs.add(UrlEscapers.urlPathSegmentEscaper().escape(pathSeg));
        }
        return Joiner.on((char)'/').join(encodedSegs);
    }

    void shutdown() {
        throw new UnsupportedOperationException();
    }

    boolean isShutDown() {
        throw new UnsupportedOperationException();
    }

    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        throw new UnsupportedOperationException();
    }

    TlsContextManager getTlsContextManager() {
        throw new UnsupportedOperationException();
    }

    ListenableFuture<Map<XdsResourceType<?>, Map<String, ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        throw new UnsupportedOperationException();
    }

    <T extends ResourceUpdate> void watchXdsResource(XdsResourceType<T> type, String resourceName, ResourceWatcher<T> watcher, Executor executor) {
        throw new UnsupportedOperationException();
    }

    <T extends ResourceUpdate> void watchXdsResource(XdsResourceType<T> type, String resourceName, ResourceWatcher<T> watcher) {
        this.watchXdsResource(type, resourceName, watcher, MoreExecutors.directExecutor());
    }

    <T extends ResourceUpdate> void cancelXdsResourceWatch(XdsResourceType<T> type, String resourceName, ResourceWatcher<T> watcher) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterDropStats addClusterDropStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    Map<Bootstrapper.ServerInfo, LoadReportClient> getServerLrsClientMap() {
        throw new UnsupportedOperationException();
    }

    static interface TimerLaunch {
        public void startSubscriberTimersIfNeeded(Bootstrapper.ServerInfo var1);
    }

    static interface ResourceStore {
        @Nullable
        public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo var1, XdsResourceType<? extends ResourceUpdate> var2);

        public Map<String, XdsResourceType<?>> getSubscribedResourceTypesWithTypeUrl();
    }

    static interface XdsResponseHandler {
        public void handleResourceResponse(XdsResourceType<?> var1, Bootstrapper.ServerInfo var2, String var3, List<Any> var4, String var5, ProcessingTracker var6);

        public void handleStreamClosed(Status var1);

        public void handleStreamRestarted(Bootstrapper.ServerInfo var1);
    }

    static final class ProcessingTracker {
        private final AtomicInteger pendingTask = new AtomicInteger(1);
        private final Executor executor;
        private final Runnable completionListener;

        ProcessingTracker(Runnable completionListener, Executor executor) {
            this.executor = executor;
            this.completionListener = completionListener;
        }

        void startTask() {
            this.pendingTask.incrementAndGet();
        }

        void onComplete() {
            if (this.pendingTask.decrementAndGet() == 0) {
                this.executor.execute(this.completionListener);
            }
        }
    }

    static final class ResourceMetadata {
        private final String version;
        private final ResourceMetadataStatus status;
        private final long updateTimeNanos;
        @Nullable
        private final Any rawResource;
        @Nullable
        private final UpdateFailureState errorState;

        private ResourceMetadata(ResourceMetadataStatus status, String version, long updateTimeNanos, @Nullable Any rawResource, @Nullable UpdateFailureState errorState) {
            this.status = (ResourceMetadataStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            this.updateTimeNanos = updateTimeNanos;
            this.rawResource = rawResource;
            this.errorState = errorState;
        }

        static ResourceMetadata newResourceMetadataUnknown() {
            return new ResourceMetadata(ResourceMetadataStatus.UNKNOWN, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataRequested() {
            return new ResourceMetadata(ResourceMetadataStatus.REQUESTED, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataDoesNotExist() {
            return new ResourceMetadata(ResourceMetadataStatus.DOES_NOT_EXIST, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataAcked(Any rawResource, String version, long updateTimeNanos) {
            Preconditions.checkNotNull((Object)rawResource, (Object)"rawResource");
            return new ResourceMetadata(ResourceMetadataStatus.ACKED, version, updateTimeNanos, rawResource, null);
        }

        static ResourceMetadata newResourceMetadataNacked(ResourceMetadata metadata, String failedVersion, long failedUpdateTime, String failedDetails) {
            Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
            return new ResourceMetadata(ResourceMetadataStatus.NACKED, metadata.getVersion(), metadata.getUpdateTimeNanos(), metadata.getRawResource(), new UpdateFailureState(failedVersion, failedUpdateTime, failedDetails));
        }

        String getVersion() {
            return this.version;
        }

        ResourceMetadataStatus getStatus() {
            return this.status;
        }

        long getUpdateTimeNanos() {
            return this.updateTimeNanos;
        }

        @Nullable
        Any getRawResource() {
            return this.rawResource;
        }

        @Nullable
        UpdateFailureState getErrorState() {
            return this.errorState;
        }

        static final class UpdateFailureState {
            private final String failedVersion;
            private final long failedUpdateTimeNanos;
            private final String failedDetails;

            private UpdateFailureState(String failedVersion, long failedUpdateTimeNanos, String failedDetails) {
                this.failedVersion = (String)Preconditions.checkNotNull((Object)failedVersion, (Object)"failedVersion");
                this.failedUpdateTimeNanos = failedUpdateTimeNanos;
                this.failedDetails = (String)Preconditions.checkNotNull((Object)failedDetails, (Object)"failedDetails");
            }

            String getFailedVersion() {
                return this.failedVersion;
            }

            long getFailedUpdateTimeNanos() {
                return this.failedUpdateTimeNanos;
            }

            String getFailedDetails() {
                return this.failedDetails;
            }
        }

        static enum ResourceMetadataStatus {
            UNKNOWN,
            REQUESTED,
            DOES_NOT_EXIST,
            ACKED,
            NACKED;

        }
    }

    static interface ResourceWatcher<T extends ResourceUpdate> {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);

        public void onChanged(T var1);
    }

    static interface ResourceUpdate {
    }
}

