/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import zeenea.connector.commons.json.JsonParsingException;
import zeenea.connector.commons.json.JsonSerializationException;
import zeenea.connector.commons.util.StringUtil;

public enum YamlMapper {
    instance;

    private static final PrettyPrinter prettyPrinter;
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static YamlMapper of() {
        return instance;
    }

    private YamlMapper() {
        this.mapper.registerModule((Module)new Jdk8Module());
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        this.mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public <T> JavaType constructType(Class<T> klass) {
        return this.mapper.constructType(klass);
    }

    public <T> JavaType constructType(TypeReference<T> klass) {
        return this.mapper.getTypeFactory().constructType(klass);
    }

    public <T> byte[] writeAsBytes(T o) {
        try {
            return this.mapper.writeValueAsBytes(o);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationException(String.format("Fails to jsonify '%s' '%s'", o.getClass().getName(), o), e);
        }
    }

    public <T> String prettyPrint(T o, int indent) {
        try {
            return StringUtil.indent((String)this.mapper.writer(prettyPrinter).writeValueAsString(o), (int)indent);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationException(String.format("Fails to jsonify '%s' '%s'", o.getClass().getName(), o), e);
        }
    }

    public <T> T readUrl(URL url, Class<T> klass) {
        return this.readUrl(url, this.mapper.constructType(klass));
    }

    public <T> T readUrl(URL url, TypeReference<T> typeReference) {
        return this.readUrl(url, this.mapper.constructType(typeReference));
    }

    public <T> T readUrl(URL url, JavaType type) {
        try {
            return (T)this.mapper.readValue(url, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing url '%s' to '%s': %s", url, type.getTypeName(), e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JsonParsingException(String.format("Failed reading url '%s': %s", url, e.getMessage()), e);
        }
    }

    public <T> T readValue(String json, Class<T> klass) {
        return this.readValue(json, this.mapper.constructType(klass));
    }

    public <T> T readValue(String json, TypeReference<T> typeReference) {
        return this.readValue(json, this.mapper.constructType(typeReference));
    }

    public <T> T readValue(String json, JavaType type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing string '%s' to '%s': %s", json, type.getTypeName(), e.getMessage()), e);
        }
    }

    public <T> T readFromFile(Path path, Class<T> klass) {
        return this.readFromFile(path, this.mapper.constructType(klass));
    }

    public <T> T readFromFile(Path path, TypeReference<T> typeReference) {
        return this.readFromFile(path, this.mapper.constructType(typeReference));
    }

    public <T> T readFromFile(Path path, JavaType type) {
        return this.readFromFile(path.toFile(), type);
    }

    public <T> T readFromFile(File file, Class<T> klass) {
        return this.readFromFile(file, this.mapper.constructType(klass));
    }

    public <T> T readFromFile(File file, TypeReference<T> typeReference) {
        return this.readFromFile(file, this.mapper.constructType(typeReference));
    }

    public <T> T readFromFile(File file, JavaType type) {
        try {
            return (T)this.mapper.readValue(file, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing file '%s' to '%s': %s", file, type.getTypeName(), e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JsonParsingException(String.format("Failed reading file '%s': %s", file, e.getMessage()), e);
        }
    }

    public <T> T readFromInputStream(InputStream is, Class<T> klass) {
        return this.readFromInputStream(is, this.mapper.constructType(klass));
    }

    public <T> T readFromInputStream(InputStream is, TypeReference<T> typeReference) {
        return this.readFromInputStream(is, this.mapper.constructType(typeReference));
    }

    public <T> T readFromInputStream(InputStream is, JavaType type) {
        try {
            return (T)this.mapper.readValue(is, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing input stream to '%s': %s", type.getTypeName(), e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JsonParsingException(String.format("Failed reading input stream : %s", e.getMessage()), e);
        }
    }

    public <T> T readFromBytes(byte[] src, Class<T> klass) {
        return this.readFromBytes(src, this.mapper.constructType(klass));
    }

    public <T> T readFromBytes(byte[] src, TypeReference<T> typeReference) {
        return this.readFromBytes(src, this.mapper.constructType(typeReference));
    }

    public <T> T readFromBytes(byte[] src, JavaType type) {
        try {
            return (T)this.mapper.readValue(src, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing byte array to '%s': %s", type.getTypeName(), e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JsonParsingException(String.format("Failed reading byte array : %s", e.getMessage()), e);
        }
    }

    public <T> T readFromReader(Reader reader, Class<T> klass) {
        return this.readFromReader(reader, this.mapper.constructType(klass));
    }

    public <T> T readFromReader(Reader reader, TypeReference<T> typeReference) {
        return this.readFromReader(reader, this.mapper.constructType(typeReference));
    }

    public <T> T readFromReader(Reader reader, JavaType type) {
        try {
            return (T)this.mapper.readValue(reader, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing reader to '%s': %s", type.getTypeName(), e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JsonParsingException(String.format("Failed reading reader : %s", e.getMessage()), e);
        }
    }

    public <T> T readFromDataInput(DataInput src, Class<T> klass) {
        return this.readFromDataInput(src, this.mapper.constructType(klass));
    }

    public <T> T readFromDataInput(DataInput src, TypeReference<T> typeReference) {
        return this.readFromDataInput(src, this.mapper.constructType(typeReference));
    }

    public <T> T readFromDataInput(DataInput src, JavaType type) {
        try {
            return (T)this.mapper.readValue(src, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonParsingException(String.format("Failed parsing data input to '%s': %s", type.getTypeName(), e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JsonParsingException(String.format("Failed reading data input : %s", e.getMessage()), e);
        }
    }

    static {
        prettyPrinter = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }
}

