package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ViewDetail}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableViewDetail.builder()}.
 */
@Generated(from = "ViewDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableViewDetail implements ViewDetail {
  private final List<Field> schema;
  private final List<Tag> tags;
  private final List<Category> categories;

  private ImmutableViewDetail(ImmutableViewDetail.Builder builder) {
    if (builder.schemaIsSet()) {
      initShim.schema(List.copyOf(builder.schema));
    }
    if (builder.tagsIsSet()) {
      initShim.tags(List.copyOf(builder.tags));
    }
    if (builder.categoriesIsSet()) {
      initShim.categories(List.copyOf(builder.categories));
    }
    this.schema = initShim.getSchema();
    this.tags = initShim.getTags();
    this.categories = initShim.getCategories();
    this.initShim = null;
  }

  private ImmutableViewDetail(
      List<Field> schema,
      List<Tag> tags,
      List<Category> categories) {
    this.schema = schema;
    this.tags = tags;
    this.categories = categories;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ViewDetail", generator = "Immutables")
  private final class InitShim {
    private byte schemaBuildStage = STAGE_UNINITIALIZED;
    private List<Field> schema;

    List<Field> getSchema() {
      if (schemaBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemaBuildStage == STAGE_UNINITIALIZED) {
        schemaBuildStage = STAGE_INITIALIZING;
        this.schema = getSchemaInitialize() instanceof Collection<?>
       ? List.copyOf((Collection<? extends Field>) getSchemaInitialize())
       : StreamSupport.stream(getSchemaInitialize().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
        schemaBuildStage = STAGE_INITIALIZED;
      }
      return this.schema;
    }

    void schema(List<Field> schema) {
      this.schema = schema;
      schemaBuildStage = STAGE_INITIALIZED;
    }

    private byte tagsBuildStage = STAGE_UNINITIALIZED;
    private List<Tag> tags;

    List<Tag> getTags() {
      if (tagsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tagsBuildStage == STAGE_UNINITIALIZED) {
        tagsBuildStage = STAGE_INITIALIZING;
        this.tags = getTagsInitialize() instanceof Collection<?>
       ? List.copyOf((Collection<? extends Tag>) getTagsInitialize())
       : StreamSupport.stream(getTagsInitialize().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
        tagsBuildStage = STAGE_INITIALIZED;
      }
      return this.tags;
    }

    void tags(List<Tag> tags) {
      this.tags = tags;
      tagsBuildStage = STAGE_INITIALIZED;
    }

    private byte categoriesBuildStage = STAGE_UNINITIALIZED;
    private List<Category> categories;

    List<Category> getCategories() {
      if (categoriesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (categoriesBuildStage == STAGE_UNINITIALIZED) {
        categoriesBuildStage = STAGE_INITIALIZING;
        this.categories = getCategoriesInitialize() instanceof Collection<?>
       ? List.copyOf((Collection<? extends Category>) getCategoriesInitialize())
       : StreamSupport.stream(getCategoriesInitialize().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
        categoriesBuildStage = STAGE_INITIALIZED;
      }
      return this.categories;
    }

    void categories(List<Category> categories) {
      this.categories = categories;
      categoriesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (schemaBuildStage == STAGE_INITIALIZING) attributes.add("schema");
      if (tagsBuildStage == STAGE_INITIALIZING) attributes.add("tags");
      if (categoriesBuildStage == STAGE_INITIALIZING) attributes.add("categories");
      return "Cannot build ViewDetail, attribute initializers form cycle " + attributes;
    }
  }

  private List<Field> getSchemaInitialize() {
    return ViewDetail.super.getSchema();
  }

  private List<Tag> getTagsInitialize() {
    return ViewDetail.super.getTags();
  }

  private List<Category> getCategoriesInitialize() {
    return ViewDetail.super.getCategories();
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @Override
  public List<Field> getSchema() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSchema()
        : this.schema;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public List<Tag> getTags() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTags()
        : this.tags;
  }

  /**
   * @return The value of the {@code categories} attribute
   */
  @JsonProperty("categories")
  @Override
  public List<Category> getCategories() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCategories()
        : this.categories;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDetail#getSchema() schema}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDetail withSchema(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableViewDetail(newValue, this.tags, this.categories);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDetail#getSchema() schema}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of schema elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDetail withSchema(Iterable<? extends Field> elements) {
    if (this.schema == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableViewDetail(newValue, this.tags, this.categories);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDetail#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDetail withTags(Tag... elements) {
    List<Tag> newValue = List.of(elements);
    return new ImmutableViewDetail(this.schema, newValue, this.categories);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDetail#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDetail withTags(Iterable<? extends Tag> elements) {
    if (this.tags == elements) return this;
    List<Tag> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Tag>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableViewDetail(this.schema, newValue, this.categories);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDetail#getCategories() categories}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDetail withCategories(Category... elements) {
    List<Category> newValue = List.of(elements);
    return new ImmutableViewDetail(this.schema, this.tags, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDetail#getCategories() categories}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of categories elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDetail withCategories(Iterable<? extends Category> elements) {
    if (this.categories == elements) return this;
    List<Category> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Category>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableViewDetail(this.schema, this.tags, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableViewDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableViewDetail
        && equalTo(0, (ImmutableViewDetail) another);
  }

  private boolean equalTo(int synthetic, ImmutableViewDetail another) {
    return schema.equals(another.schema)
        && tags.equals(another.tags)
        && categories.equals(another.categories);
  }

  /**
   * Computes a hash code from attributes: {@code schema}, {@code tags}, {@code categories}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + schema.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + categories.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewDetail{"
        + "schema=" + schema
        + ", tags=" + tags
        + ", categories=" + categories
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ViewDetail", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewDetail {
    @Nullable List<Field> schema = List.of();
    boolean schemaIsSet;
    @Nullable List<Tag> tags = List.of();
    boolean tagsIsSet;
    @Nullable List<Category> categories = List.of();
    boolean categoriesIsSet;
    @JsonProperty("schema")
    public void setSchema(List<Field> schema) {
      this.schema = schema;
      this.schemaIsSet = null != schema;
    }
    @JsonProperty("tags")
    public void setTags(List<Tag> tags) {
      this.tags = tags;
      this.tagsIsSet = null != tags;
    }
    @JsonProperty("categories")
    public void setCategories(List<Category> categories) {
      this.categories = categories;
      this.categoriesIsSet = null != categories;
    }
    @Override
    public List<Field> getSchema() { throw new UnsupportedOperationException(); }
    @Override
    public List<Tag> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public List<Category> getCategories() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableViewDetail fromJson(Json json) {
    ImmutableViewDetail.Builder builder = ImmutableViewDetail.builder();
    if (json.schemaIsSet) {
      builder.addAllSchema(json.schema);
    }
    if (json.tagsIsSet) {
      builder.addAllTags(json.tags);
    }
    if (json.categoriesIsSet) {
      builder.addAllCategories(json.categories);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewDetail} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewDetail instance
   */
  public static ImmutableViewDetail copyOf(ViewDetail instance) {
    if (instance instanceof ImmutableViewDetail) {
      return (ImmutableViewDetail) instance;
    }
    return ImmutableViewDetail.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableViewDetail ImmutableViewDetail}.
   * <pre>
   * ImmutableViewDetail.builder()
   *    .addSchema|addAllSchema(zeenea.connector.denodo.client.rest.Field) // {@link ViewDetail#getSchema() schema} elements
   *    .addTags|addAllTags(zeenea.connector.denodo.client.rest.Tag) // {@link ViewDetail#getTags() tags} elements
   *    .addCategories|addAllCategories(zeenea.connector.denodo.client.rest.Category) // {@link ViewDetail#getCategories() categories} elements
   *    .build();
   * </pre>
   * @return A new ImmutableViewDetail builder
   */
  public static ImmutableViewDetail.Builder builder() {
    return new ImmutableViewDetail.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableViewDetail ImmutableViewDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ViewDetail", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SCHEMA = 0x1L;
    private static final long OPT_BIT_TAGS = 0x2L;
    private static final long OPT_BIT_CATEGORIES = 0x4L;
    private long optBits;

    private List<Field> schema = new ArrayList<Field>();
    private List<Tag> tags = new ArrayList<Tag>();
    private List<Category> categories = new ArrayList<Category>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewDetail instance) {
      Objects.requireNonNull(instance, "instance");
      addAllSchema(instance.getSchema());
      addAllTags(instance.getTags());
      addAllCategories(instance.getCategories());
      return this;
    }

    /**
     * Adds one element to {@link ViewDetail#getSchema() schema} list.
     * @param element A schema element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchema(Field element) {
      this.schema.add(Objects.requireNonNull(element, "schema element"));
      optBits |= OPT_BIT_SCHEMA;
      return this;
    }

    /**
     * Adds elements to {@link ViewDetail#getSchema() schema} list.
     * @param elements An array of schema elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchema(Field... elements) {
      for (Field element : elements) {
        this.schema.add(Objects.requireNonNull(element, "schema element"));
      }
      optBits |= OPT_BIT_SCHEMA;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ViewDetail#getSchema() schema} list.
     * @param elements An iterable of schema elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema")
    public final Builder schema(Iterable<? extends Field> elements) {
      this.schema.clear();
      return addAllSchema(elements);
    }

    /**
     * Adds elements to {@link ViewDetail#getSchema() schema} list.
     * @param elements An iterable of schema elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchema(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.schema.add(Objects.requireNonNull(element, "schema element"));
      }
      optBits |= OPT_BIT_SCHEMA;
      return this;
    }

    /**
     * Adds one element to {@link ViewDetail#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(Tag element) {
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      optBits |= OPT_BIT_TAGS;
      return this;
    }

    /**
     * Adds elements to {@link ViewDetail#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(Tag... elements) {
      for (Tag element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      optBits |= OPT_BIT_TAGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ViewDetail#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(Iterable<? extends Tag> elements) {
      this.tags.clear();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link ViewDetail#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<? extends Tag> elements) {
      for (Tag element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      optBits |= OPT_BIT_TAGS;
      return this;
    }

    /**
     * Adds one element to {@link ViewDetail#getCategories() categories} list.
     * @param element A categories element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCategories(Category element) {
      this.categories.add(Objects.requireNonNull(element, "categories element"));
      optBits |= OPT_BIT_CATEGORIES;
      return this;
    }

    /**
     * Adds elements to {@link ViewDetail#getCategories() categories} list.
     * @param elements An array of categories elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCategories(Category... elements) {
      for (Category element : elements) {
        this.categories.add(Objects.requireNonNull(element, "categories element"));
      }
      optBits |= OPT_BIT_CATEGORIES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ViewDetail#getCategories() categories} list.
     * @param elements An iterable of categories elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("categories")
    public final Builder categories(Iterable<? extends Category> elements) {
      this.categories.clear();
      return addAllCategories(elements);
    }

    /**
     * Adds elements to {@link ViewDetail#getCategories() categories} list.
     * @param elements An iterable of categories elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCategories(Iterable<? extends Category> elements) {
      for (Category element : elements) {
        this.categories.add(Objects.requireNonNull(element, "categories element"));
      }
      optBits |= OPT_BIT_CATEGORIES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableViewDetail ImmutableViewDetail}.
     * @return An immutable instance of ViewDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableViewDetail build() {
      return new ImmutableViewDetail(this);
    }

    private boolean schemaIsSet() {
      return (optBits & OPT_BIT_SCHEMA) != 0;
    }

    private boolean tagsIsSet() {
      return (optBits & OPT_BIT_TAGS) != 0;
    }

    private boolean categoriesIsSet() {
      return (optBits & OPT_BIT_CATEGORIES) != 0;
    }
  }
}
