package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link View}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableView.builder()}.
 */
@Generated(from = "View", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableView implements View {
  private final String name;
  private final String description;
  private final String db;
  private final String elementType;
  private final String elementSubtype;
  private final String path;
  private final String lastModificationDate;

  private ImmutableView(
      String name,
      String description,
      String db,
      String elementType,
      String elementSubtype,
      String path,
      String lastModificationDate) {
    this.name = name;
    this.description = description;
    this.db = db;
    this.elementType = elementType;
    this.elementSubtype = elementSubtype;
    this.path = path;
    this.lastModificationDate = lastModificationDate;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code db} attribute
   */
  @JsonProperty("db")
  @Override
  public String getDb() {
    return db;
  }

  /**
   * @return The value of the {@code elementType} attribute
   */
  @JsonProperty("elementType")
  @Override
  public String getElementType() {
    return elementType;
  }

  /**
   * @return The value of the {@code elementSubtype} attribute
   */
  @JsonProperty("elementSubtype")
  @Override
  public String getElementSubtype() {
    return elementSubtype;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @JsonProperty("path")
  @Override
  public String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code lastModificationDate} attribute
   */
  @JsonProperty("lastModificationDate")
  @Override
  public String getLastModificationDate() {
    return lastModificationDate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableView(
        newValue,
        this.description,
        this.db,
        this.elementType,
        this.elementSubtype,
        this.path,
        this.lastModificationDate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableView(
        this.name,
        newValue,
        this.db,
        this.elementType,
        this.elementSubtype,
        this.path,
        this.lastModificationDate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getDb() db} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for db
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withDb(String value) {
    String newValue = Objects.requireNonNull(value, "db");
    if (this.db.equals(newValue)) return this;
    return new ImmutableView(
        this.name,
        this.description,
        newValue,
        this.elementType,
        this.elementSubtype,
        this.path,
        this.lastModificationDate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getElementType() elementType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withElementType(String value) {
    String newValue = Objects.requireNonNull(value, "elementType");
    if (this.elementType.equals(newValue)) return this;
    return new ImmutableView(
        this.name,
        this.description,
        this.db,
        newValue,
        this.elementSubtype,
        this.path,
        this.lastModificationDate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getElementSubtype() elementSubtype} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementSubtype
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withElementSubtype(String value) {
    String newValue = Objects.requireNonNull(value, "elementSubtype");
    if (this.elementSubtype.equals(newValue)) return this;
    return new ImmutableView(
        this.name,
        this.description,
        this.db,
        this.elementType,
        newValue,
        this.path,
        this.lastModificationDate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableView(
        this.name,
        this.description,
        this.db,
        this.elementType,
        this.elementSubtype,
        newValue,
        this.lastModificationDate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link View#getLastModificationDate() lastModificationDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastModificationDate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableView withLastModificationDate(String value) {
    String newValue = Objects.requireNonNull(value, "lastModificationDate");
    if (this.lastModificationDate.equals(newValue)) return this;
    return new ImmutableView(
        this.name,
        this.description,
        this.db,
        this.elementType,
        this.elementSubtype,
        this.path,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableView} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableView
        && equalTo(0, (ImmutableView) another);
  }

  private boolean equalTo(int synthetic, ImmutableView another) {
    return name.equals(another.name)
        && description.equals(another.description)
        && db.equals(another.db)
        && elementType.equals(another.elementType)
        && elementSubtype.equals(another.elementSubtype)
        && path.equals(another.path)
        && lastModificationDate.equals(another.lastModificationDate);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code db}, {@code elementType}, {@code elementSubtype}, {@code path}, {@code lastModificationDate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + db.hashCode();
    h += (h << 5) + elementType.hashCode();
    h += (h << 5) + elementSubtype.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + lastModificationDate.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code View} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "View{"
        + "name=" + name
        + ", description=" + description
        + ", db=" + db
        + ", elementType=" + elementType
        + ", elementSubtype=" + elementSubtype
        + ", path=" + path
        + ", lastModificationDate=" + lastModificationDate
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "View", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements View {
    @Nullable String name;
    @Nullable String description;
    @Nullable String db;
    @Nullable String elementType;
    @Nullable String elementSubtype;
    @Nullable String path;
    @Nullable String lastModificationDate;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("db")
    public void setDb(String db) {
      this.db = db;
    }
    @JsonProperty("elementType")
    public void setElementType(String elementType) {
      this.elementType = elementType;
    }
    @JsonProperty("elementSubtype")
    public void setElementSubtype(String elementSubtype) {
      this.elementSubtype = elementSubtype;
    }
    @JsonProperty("path")
    public void setPath(String path) {
      this.path = path;
    }
    @JsonProperty("lastModificationDate")
    public void setLastModificationDate(String lastModificationDate) {
      this.lastModificationDate = lastModificationDate;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDb() { throw new UnsupportedOperationException(); }
    @Override
    public String getElementType() { throw new UnsupportedOperationException(); }
    @Override
    public String getElementSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public String getLastModificationDate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableView fromJson(Json json) {
    ImmutableView.Builder builder = ImmutableView.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.db != null) {
      builder.db(json.db);
    }
    if (json.elementType != null) {
      builder.elementType(json.elementType);
    }
    if (json.elementSubtype != null) {
      builder.elementSubtype(json.elementSubtype);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.lastModificationDate != null) {
      builder.lastModificationDate(json.lastModificationDate);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link View} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable View instance
   */
  public static ImmutableView copyOf(View instance) {
    if (instance instanceof ImmutableView) {
      return (ImmutableView) instance;
    }
    return ImmutableView.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableView ImmutableView}.
   * <pre>
   * ImmutableView.builder()
   *    .name(String) // required {@link View#getName() name}
   *    .description(String) // required {@link View#getDescription() description}
   *    .db(String) // required {@link View#getDb() db}
   *    .elementType(String) // required {@link View#getElementType() elementType}
   *    .elementSubtype(String) // required {@link View#getElementSubtype() elementSubtype}
   *    .path(String) // required {@link View#getPath() path}
   *    .lastModificationDate(String) // required {@link View#getLastModificationDate() lastModificationDate}
   *    .build();
   * </pre>
   * @return A new ImmutableView builder
   */
  public static ImmutableView.Builder builder() {
    return new ImmutableView.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableView ImmutableView}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "View", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private static final long INIT_BIT_DB = 0x4L;
    private static final long INIT_BIT_ELEMENT_TYPE = 0x8L;
    private static final long INIT_BIT_ELEMENT_SUBTYPE = 0x10L;
    private static final long INIT_BIT_PATH = 0x20L;
    private static final long INIT_BIT_LAST_MODIFICATION_DATE = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String db;
    private @Nullable String elementType;
    private @Nullable String elementSubtype;
    private @Nullable String path;
    private @Nullable String lastModificationDate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code View} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(View instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.description(instance.getDescription());
      this.db(instance.getDb());
      this.elementType(instance.getElementType());
      this.elementSubtype(instance.getElementSubtype());
      this.path(instance.getPath());
      this.lastModificationDate(instance.getLastModificationDate());
      return this;
    }

    /**
     * Initializes the value for the {@link View#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link View#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link View#getDb() db} attribute.
     * @param db The value for db 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("db")
    public final Builder db(String db) {
      this.db = Objects.requireNonNull(db, "db");
      initBits &= ~INIT_BIT_DB;
      return this;
    }

    /**
     * Initializes the value for the {@link View#getElementType() elementType} attribute.
     * @param elementType The value for elementType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("elementType")
    public final Builder elementType(String elementType) {
      this.elementType = Objects.requireNonNull(elementType, "elementType");
      initBits &= ~INIT_BIT_ELEMENT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link View#getElementSubtype() elementSubtype} attribute.
     * @param elementSubtype The value for elementSubtype 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("elementSubtype")
    public final Builder elementSubtype(String elementSubtype) {
      this.elementSubtype = Objects.requireNonNull(elementSubtype, "elementSubtype");
      initBits &= ~INIT_BIT_ELEMENT_SUBTYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link View#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link View#getLastModificationDate() lastModificationDate} attribute.
     * @param lastModificationDate The value for lastModificationDate 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastModificationDate")
    public final Builder lastModificationDate(String lastModificationDate) {
      this.lastModificationDate = Objects.requireNonNull(lastModificationDate, "lastModificationDate");
      initBits &= ~INIT_BIT_LAST_MODIFICATION_DATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableView ImmutableView}.
     * @return An immutable instance of View
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableView build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableView(name, description, db, elementType, elementSubtype, path, lastModificationDate);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_DB) != 0) attributes.add("db");
      if ((initBits & INIT_BIT_ELEMENT_TYPE) != 0) attributes.add("elementType");
      if ((initBits & INIT_BIT_ELEMENT_SUBTYPE) != 0) attributes.add("elementSubtype");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_LAST_MODIFICATION_DATE) != 0) attributes.add("lastModificationDate");
      return "Cannot build View, some of required attributes are not set " + attributes;
    }
  }
}
