package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Server}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServer.builder()}.
 */
@Generated(from = "Server", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableServer implements Server {
  private final String url;
  private final Integer id;

  private ImmutableServer(String url, Integer id) {
    this.url = url;
    this.id = id;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty("url")
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public Integer getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Server#getUrl() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServer withUrl(String value) {
    String newValue = Objects.requireNonNull(value, "url");
    if (this.url.equals(newValue)) return this;
    return new ImmutableServer(newValue, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Server#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableServer withId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableServer(this.url, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServer
        && equalTo(0, (ImmutableServer) another);
  }

  private boolean equalTo(int synthetic, ImmutableServer another) {
    return url.equals(another.url)
        && id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + url.hashCode();
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Server} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Server{"
        + "url=" + url
        + ", id=" + id
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Server", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Server {
    @Nullable String url;
    @Nullable Integer id;
    @JsonProperty("url")
    public void setUrl(String url) {
      this.url = url;
    }
    @JsonProperty("id")
    public void setId(Integer id) {
      this.id = id;
    }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableServer fromJson(Json json) {
    ImmutableServer.Builder builder = ImmutableServer.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Server} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Server instance
   */
  public static ImmutableServer copyOf(Server instance) {
    if (instance instanceof ImmutableServer) {
      return (ImmutableServer) instance;
    }
    return ImmutableServer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServer ImmutableServer}.
   * <pre>
   * ImmutableServer.builder()
   *    .url(String) // required {@link Server#getUrl() url}
   *    .id(Integer) // required {@link Server#getId() id}
   *    .build();
   * </pre>
   * @return A new ImmutableServer builder
   */
  public static ImmutableServer.Builder builder() {
    return new ImmutableServer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServer ImmutableServer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Server", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String url;
    private @Nullable Integer id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Server} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Server instance) {
      Objects.requireNonNull(instance, "instance");
      this.url(instance.getUrl());
      this.id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link Server#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("url")
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link Server#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(Integer id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServer ImmutableServer}.
     * @return An immutable instance of Server
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServer build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableServer(url, id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Server, some of required attributes are not set " + attributes;
    }
  }
}
