package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link SearchValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchValue.builder()}.
 */
@Generated(from = "SearchValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearchValue implements SearchValue {
  private final String column;
  private final String dbName;
  private final @Nullable String value;

  private ImmutableSearchValue(
      String column,
      String dbName,
      @Nullable String value) {
    this.column = column;
    this.dbName = dbName;
    this.value = value;
  }

  /**
   * @return The value of the {@code column} attribute
   */
  @JsonProperty("column")
  @Override
  public String column() {
    return column;
  }

  /**
   * @return The value of the {@code dbName} attribute
   */
  @JsonProperty("dbName")
  @Override
  public String dbName() {
    return dbName;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public @Nullable String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchValue#column() column} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for column
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchValue withColumn(String value) {
    String newValue = Objects.requireNonNull(value, "column");
    if (this.column.equals(newValue)) return this;
    return new ImmutableSearchValue(newValue, this.dbName, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchValue#dbName() dbName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dbName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchValue withDbName(String value) {
    String newValue = Objects.requireNonNull(value, "dbName");
    if (this.dbName.equals(newValue)) return this;
    return new ImmutableSearchValue(this.column, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchValue#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchValue withValue(@Nullable String value) {
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableSearchValue(this.column, this.dbName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchValue
        && equalTo(0, (ImmutableSearchValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchValue another) {
    return column.equals(another.column)
        && dbName.equals(another.dbName)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code column}, {@code dbName}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + column.hashCode();
    h += (h << 5) + dbName.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchValue{"
        + "column=" + column
        + ", dbName=" + dbName
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchValue", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchValue {
    @javax.annotation.Nullable String column;
    @javax.annotation.Nullable String dbName;
    @javax.annotation.Nullable String value;
    @JsonProperty("column")
    public void setColumn(String column) {
      this.column = column;
    }
    @JsonProperty("dbName")
    public void setDbName(String dbName) {
      this.dbName = dbName;
    }
    @JsonProperty("value")
    public void setValue(@Nullable String value) {
      this.value = value;
    }
    @Override
    public String column() { throw new UnsupportedOperationException(); }
    @Override
    public String dbName() { throw new UnsupportedOperationException(); }
    @Override
    public String value() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchValue fromJson(Json json) {
    ImmutableSearchValue.Builder builder = ImmutableSearchValue.builder();
    if (json.column != null) {
      builder.column(json.column);
    }
    if (json.dbName != null) {
      builder.dbName(json.dbName);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchValue instance
   */
  public static ImmutableSearchValue copyOf(SearchValue instance) {
    if (instance instanceof ImmutableSearchValue) {
      return (ImmutableSearchValue) instance;
    }
    return ImmutableSearchValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchValue ImmutableSearchValue}.
   * <pre>
   * ImmutableSearchValue.builder()
   *    .column(String) // required {@link SearchValue#column() column}
   *    .dbName(String) // required {@link SearchValue#dbName() dbName}
   *    .value(String | null) // nullable {@link SearchValue#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchValue builder
   */
  public static ImmutableSearchValue.Builder builder() {
    return new ImmutableSearchValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchValue ImmutableSearchValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COLUMN = 0x1L;
    private static final long INIT_BIT_DB_NAME = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String column;
    private @javax.annotation.Nullable String dbName;
    private @javax.annotation.Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.column(instance.column());
      this.dbName(instance.dbName());
      @Nullable String valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SearchValue#column() column} attribute.
     * @param column The value for column 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("column")
    public final Builder column(String column) {
      this.column = Objects.requireNonNull(column, "column");
      initBits &= ~INIT_BIT_COLUMN;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchValue#dbName() dbName} attribute.
     * @param dbName The value for dbName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dbName")
    public final Builder dbName(String dbName) {
      this.dbName = Objects.requireNonNull(dbName, "dbName");
      initBits &= ~INIT_BIT_DB_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchValue#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchValue ImmutableSearchValue}.
     * @return An immutable instance of SearchValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSearchValue(column, dbName, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COLUMN) != 0) attributes.add("column");
      if ((initBits & INIT_BIT_DB_NAME) != 0) attributes.add("dbName");
      return "Cannot build SearchValue, some of required attributes are not set " + attributes;
    }
  }
}
