package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchRow.builder()}.
 */
@Generated(from = "SearchRow", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearchRow implements SearchRow {
  private final List<SearchValue> values;

  private ImmutableSearchRow(ImmutableSearchRow.Builder builder) {
    this.values = builder.valuesIsSet()
        ? List.copyOf(builder.values)
        : SearchRow.super.values() instanceof Collection<?>
       ? List.copyOf((Collection<? extends SearchValue>) SearchRow.super.values())
       : StreamSupport.stream(SearchRow.super.values().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
  }

  private ImmutableSearchRow(List<SearchValue> values) {
    this.values = values;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @JsonProperty("values")
  @Override
  public List<SearchValue> values() {
    return values;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchRow#values() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchRow withValues(SearchValue... elements) {
    List<SearchValue> newValue = List.of(elements);
    return new ImmutableSearchRow(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchRow#values() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchRow withValues(Iterable<? extends SearchValue> elements) {
    if (this.values == elements) return this;
    List<SearchValue> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends SearchValue>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSearchRow(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchRow
        && equalTo(0, (ImmutableSearchRow) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchRow another) {
    return values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SearchRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchRow{"
        + "values=" + values
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchRow", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchRow {
    @Nullable List<SearchValue> values = List.of();
    boolean valuesIsSet;
    @JsonProperty("values")
    public void setValues(List<SearchValue> values) {
      this.values = values;
      this.valuesIsSet = null != values;
    }
    @Override
    public List<SearchValue> values() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchRow fromJson(Json json) {
    ImmutableSearchRow.Builder builder = ImmutableSearchRow.builder();
    if (json.valuesIsSet) {
      builder.addAllValues(json.values);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchRow instance
   */
  public static ImmutableSearchRow copyOf(SearchRow instance) {
    if (instance instanceof ImmutableSearchRow) {
      return (ImmutableSearchRow) instance;
    }
    return ImmutableSearchRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchRow ImmutableSearchRow}.
   * <pre>
   * ImmutableSearchRow.builder()
   *    .addValues|addAllValues(zeenea.connector.denodo.client.rest.SearchValue) // {@link SearchRow#values() values} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSearchRow builder
   */
  public static ImmutableSearchRow.Builder builder() {
    return new ImmutableSearchRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchRow ImmutableSearchRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_VALUES = 0x1L;
    private long optBits;

    private List<SearchValue> values = new ArrayList<SearchValue>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchRow instance) {
      Objects.requireNonNull(instance, "instance");
      addAllValues(instance.values());
      return this;
    }

    /**
     * Adds one element to {@link SearchRow#values() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValues(SearchValue element) {
      this.values.add(Objects.requireNonNull(element, "values element"));
      optBits |= OPT_BIT_VALUES;
      return this;
    }

    /**
     * Adds elements to {@link SearchRow#values() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValues(SearchValue... elements) {
      for (SearchValue element : elements) {
        this.values.add(Objects.requireNonNull(element, "values element"));
      }
      optBits |= OPT_BIT_VALUES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SearchRow#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("values")
    public final Builder values(Iterable<? extends SearchValue> elements) {
      this.values.clear();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link SearchRow#values() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValues(Iterable<? extends SearchValue> elements) {
      for (SearchValue element : elements) {
        this.values.add(Objects.requireNonNull(element, "values element"));
      }
      optBits |= OPT_BIT_VALUES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchRow ImmutableSearchRow}.
     * @return An immutable instance of SearchRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchRow build() {
      return new ImmutableSearchRow(this);
    }

    private boolean valuesIsSet() {
      return (optBits & OPT_BIT_VALUES) != 0;
    }
  }
}
