package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchResponse.builder()}.
 */
@Generated(from = "SearchResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearchResponse implements SearchResponse {
  private final List<SearchRow> rows;

  private ImmutableSearchResponse(ImmutableSearchResponse.Builder builder) {
    this.rows = builder.rowsIsSet()
        ? List.copyOf(builder.rows)
        : SearchResponse.super.rows() instanceof Collection<?>
       ? List.copyOf((Collection<? extends SearchRow>) SearchResponse.super.rows())
       : StreamSupport.stream(SearchResponse.super.rows().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
  }

  private ImmutableSearchResponse(List<SearchRow> rows) {
    this.rows = rows;
  }

  /**
   * @return The value of the {@code rows} attribute
   */
  @JsonProperty("rows")
  @Override
  public List<SearchRow> rows() {
    return rows;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchResponse#rows() rows}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchResponse withRows(SearchRow... elements) {
    List<SearchRow> newValue = List.of(elements);
    return new ImmutableSearchResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchResponse#rows() rows}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rows elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchResponse withRows(Iterable<? extends SearchRow> elements) {
    if (this.rows == elements) return this;
    List<SearchRow> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends SearchRow>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSearchResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchResponse
        && equalTo(0, (ImmutableSearchResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchResponse another) {
    return rows.equals(another.rows);
  }

  /**
   * Computes a hash code from attributes: {@code rows}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rows.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SearchResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchResponse{"
        + "rows=" + rows
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchResponse {
    @Nullable List<SearchRow> rows = List.of();
    boolean rowsIsSet;
    @JsonProperty("rows")
    public void setRows(List<SearchRow> rows) {
      this.rows = rows;
      this.rowsIsSet = null != rows;
    }
    @Override
    public List<SearchRow> rows() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchResponse fromJson(Json json) {
    ImmutableSearchResponse.Builder builder = ImmutableSearchResponse.builder();
    if (json.rowsIsSet) {
      builder.addAllRows(json.rows);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchResponse instance
   */
  public static ImmutableSearchResponse copyOf(SearchResponse instance) {
    if (instance instanceof ImmutableSearchResponse) {
      return (ImmutableSearchResponse) instance;
    }
    return ImmutableSearchResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchResponse ImmutableSearchResponse}.
   * <pre>
   * ImmutableSearchResponse.builder()
   *    .addRows|addAllRows(zeenea.connector.denodo.client.rest.SearchRow) // {@link SearchResponse#rows() rows} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSearchResponse builder
   */
  public static ImmutableSearchResponse.Builder builder() {
    return new ImmutableSearchResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchResponse ImmutableSearchResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_ROWS = 0x1L;
    private long optBits;

    private List<SearchRow> rows = new ArrayList<SearchRow>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRows(instance.rows());
      return this;
    }

    /**
     * Adds one element to {@link SearchResponse#rows() rows} list.
     * @param element A rows element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRows(SearchRow element) {
      this.rows.add(Objects.requireNonNull(element, "rows element"));
      optBits |= OPT_BIT_ROWS;
      return this;
    }

    /**
     * Adds elements to {@link SearchResponse#rows() rows} list.
     * @param elements An array of rows elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRows(SearchRow... elements) {
      for (SearchRow element : elements) {
        this.rows.add(Objects.requireNonNull(element, "rows element"));
      }
      optBits |= OPT_BIT_ROWS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SearchResponse#rows() rows} list.
     * @param elements An iterable of rows elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rows")
    public final Builder rows(Iterable<? extends SearchRow> elements) {
      this.rows.clear();
      return addAllRows(elements);
    }

    /**
     * Adds elements to {@link SearchResponse#rows() rows} list.
     * @param elements An iterable of rows elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRows(Iterable<? extends SearchRow> elements) {
      for (SearchRow element : elements) {
        this.rows.add(Objects.requireNonNull(element, "rows element"));
      }
      optBits |= OPT_BIT_ROWS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchResponse ImmutableSearchResponse}.
     * @return An immutable instance of SearchResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchResponse build() {
      return new ImmutableSearchResponse(this);
    }

    private boolean rowsIsSet() {
      return (optBits & OPT_BIT_ROWS) != 0;
    }
  }
}
