package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchFieldResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchFieldResponse.builder()}.
 */
@Generated(from = "SearchFieldResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearchFieldResponse
    implements SearchFieldResponse {
  private final String field;
  private final String type;
  private final @Nullable String expression;

  private ImmutableSearchFieldResponse(
      String field,
      String type,
      @Nullable String expression) {
    this.field = field;
    this.type = type;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code field} attribute
   */
  @JsonProperty("field")
  @Override
  public String field() {
    return field;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("expression")
  @Override
  public @Nullable String expression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchFieldResponse#field() field} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for field
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchFieldResponse withField(String value) {
    String newValue = Objects.requireNonNull(value, "field");
    if (this.field.equals(newValue)) return this;
    return new ImmutableSearchFieldResponse(newValue, this.type, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchFieldResponse#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchFieldResponse withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableSearchFieldResponse(this.field, newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchFieldResponse#expression() expression} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchFieldResponse withExpression(@Nullable String value) {
    if (Objects.equals(this.expression, value)) return this;
    return new ImmutableSearchFieldResponse(this.field, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchFieldResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchFieldResponse
        && equalTo(0, (ImmutableSearchFieldResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchFieldResponse another) {
    return field.equals(another.field)
        && type.equals(another.type)
        && Objects.equals(expression, another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code field}, {@code type}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + field.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(expression);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchFieldResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchFieldResponse{"
        + "field=" + field
        + ", type=" + type
        + ", expression=" + expression
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchFieldResponse", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchFieldResponse {
    @Nullable String field;
    @Nullable String type;
    @Nullable String expression;
    @JsonProperty("field")
    public void setField(String field) {
      this.field = field;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("expression")
    public void setExpression(@Nullable String expression) {
      this.expression = expression;
    }
    @Override
    public String field() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public String expression() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchFieldResponse fromJson(Json json) {
    ImmutableSearchFieldResponse.Builder builder = ImmutableSearchFieldResponse.builder();
    if (json.field != null) {
      builder.field(json.field);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchFieldResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchFieldResponse instance
   */
  public static ImmutableSearchFieldResponse copyOf(SearchFieldResponse instance) {
    if (instance instanceof ImmutableSearchFieldResponse) {
      return (ImmutableSearchFieldResponse) instance;
    }
    return ImmutableSearchFieldResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchFieldResponse ImmutableSearchFieldResponse}.
   * <pre>
   * ImmutableSearchFieldResponse.builder()
   *    .field(String) // required {@link SearchFieldResponse#field() field}
   *    .type(String) // required {@link SearchFieldResponse#type() type}
   *    .expression(String | null) // nullable {@link SearchFieldResponse#expression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchFieldResponse builder
   */
  public static ImmutableSearchFieldResponse.Builder builder() {
    return new ImmutableSearchFieldResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchFieldResponse ImmutableSearchFieldResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchFieldResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FIELD = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String field;
    private @Nullable String type;
    private @Nullable String expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.denodo.client.rest.SearchField} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchField instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.denodo.client.rest.SearchFieldResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchFieldResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof SearchField) {
        SearchField instance = (SearchField) object;
        if ((bits & 0x1L) == 0) {
          this.field(instance.field());
          bits |= 0x1L;
        }
      }
      if (object instanceof SearchFieldResponse) {
        SearchFieldResponse instance = (SearchFieldResponse) object;
        this.type(instance.type());
        if ((bits & 0x1L) == 0) {
          this.field(instance.field());
          bits |= 0x1L;
        }
        @Nullable String expressionValue = instance.expression();
        if (expressionValue != null) {
          expression(expressionValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link SearchFieldResponse#field() field} attribute.
     * @param field The value for field 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder field(String field) {
      this.field = Objects.requireNonNull(field, "field");
      initBits &= ~INIT_BIT_FIELD;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchFieldResponse#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchFieldResponse#expression() expression} attribute.
     * @param expression The value for expression (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder expression(@Nullable String expression) {
      this.expression = expression;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchFieldResponse ImmutableSearchFieldResponse}.
     * @return An immutable instance of SearchFieldResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchFieldResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSearchFieldResponse(field, type, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIELD) != 0) attributes.add("field");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build SearchFieldResponse, some of required attributes are not set " + attributes;
    }
  }
}
