package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchField}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchField.builder()}.
 */
@Generated(from = "SearchField", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearchField implements SearchField {
  private final String field;

  private ImmutableSearchField(String field) {
    this.field = field;
  }

  /**
   * @return The value of the {@code field} attribute
   */
  @JsonProperty("field")
  @Override
  public String field() {
    return field;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchField#field() field} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for field
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchField withField(String value) {
    String newValue = Objects.requireNonNull(value, "field");
    if (this.field.equals(newValue)) return this;
    return new ImmutableSearchField(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchField
        && equalTo(0, (ImmutableSearchField) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchField another) {
    return field.equals(another.field);
  }

  /**
   * Computes a hash code from attributes: {@code field}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + field.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SearchField} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchField{"
        + "field=" + field
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchField", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchField {
    @Nullable String field;
    @JsonProperty("field")
    public void setField(String field) {
      this.field = field;
    }
    @Override
    public String field() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchField fromJson(Json json) {
    ImmutableSearchField.Builder builder = ImmutableSearchField.builder();
    if (json.field != null) {
      builder.field(json.field);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchField} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchField instance
   */
  public static ImmutableSearchField copyOf(SearchField instance) {
    if (instance instanceof ImmutableSearchField) {
      return (ImmutableSearchField) instance;
    }
    return ImmutableSearchField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchField ImmutableSearchField}.
   * <pre>
   * ImmutableSearchField.builder()
   *    .field(String) // required {@link SearchField#field() field}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchField builder
   */
  public static ImmutableSearchField.Builder builder() {
    return new ImmutableSearchField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchField ImmutableSearchField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchField", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FIELD = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String field;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchField} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchField instance) {
      Objects.requireNonNull(instance, "instance");
      this.field(instance.field());
      return this;
    }

    /**
     * Initializes the value for the {@link SearchField#field() field} attribute.
     * @param field The value for field 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder field(String field) {
      this.field = Objects.requireNonNull(field, "field");
      initBits &= ~INIT_BIT_FIELD;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchField ImmutableSearchField}.
     * @return An immutable instance of SearchField
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSearchField(field);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIELD) != 0) attributes.add("field");
      return "Cannot build SearchField, some of required attributes are not set " + attributes;
    }
  }
}
