package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchCondition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchCondition.builder()}.
 */
@Generated(from = "SearchCondition", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearchCondition implements SearchCondition {
  private final String expression;

  private ImmutableSearchCondition(String expression) {
    this.expression = expression;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("expression")
  @Override
  public String expression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchCondition#expression() expression} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchCondition withExpression(String value) {
    String newValue = Objects.requireNonNull(value, "expression");
    if (this.expression.equals(newValue)) return this;
    return new ImmutableSearchCondition(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchCondition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchCondition
        && equalTo(0, (ImmutableSearchCondition) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearchCondition another) {
    return expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SearchCondition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchCondition{"
        + "expression=" + expression
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchCondition", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchCondition {
    @Nullable String expression;
    @JsonProperty("expression")
    public void setExpression(String expression) {
      this.expression = expression;
    }
    @Override
    public String expression() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchCondition fromJson(Json json) {
    ImmutableSearchCondition.Builder builder = ImmutableSearchCondition.builder();
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchCondition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchCondition instance
   */
  public static ImmutableSearchCondition copyOf(SearchCondition instance) {
    if (instance instanceof ImmutableSearchCondition) {
      return (ImmutableSearchCondition) instance;
    }
    return ImmutableSearchCondition.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchCondition ImmutableSearchCondition}.
   * <pre>
   * ImmutableSearchCondition.builder()
   *    .expression(String) // required {@link SearchCondition#expression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchCondition builder
   */
  public static ImmutableSearchCondition.Builder builder() {
    return new ImmutableSearchCondition.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchCondition ImmutableSearchCondition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchCondition", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchCondition} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchCondition instance) {
      Objects.requireNonNull(instance, "instance");
      this.expression(instance.expression());
      return this;
    }

    /**
     * Initializes the value for the {@link SearchCondition#expression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder expression(String expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchCondition ImmutableSearchCondition}.
     * @return An immutable instance of SearchCondition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchCondition build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSearchCondition(expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build SearchCondition, some of required attributes are not set " + attributes;
    }
  }
}
