package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Search}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearch.builder()}.
 */
@Generated(from = "Search", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSearch implements Search {
  private final Integer id;
  private final String database;
  private final String name;
  private final List<SearchField> orderByFields;
  private final List<SearchField> outputFields;
  private final List<SearchCondition> simpleConditions;
  private final String type;
  private final String view;

  private ImmutableSearch(ImmutableSearch.Builder builder) {
    this.database = builder.database;
    this.name = builder.name;
    this.orderByFields = List.copyOf(builder.orderByFields);
    this.outputFields = List.copyOf(builder.outputFields);
    this.type = builder.type;
    this.view = builder.view;
    if (builder.id != null) {
      initShim.id(builder.id);
    }
    if (builder.simpleConditionsIsSet()) {
      initShim.simpleConditions(List.copyOf(builder.simpleConditions));
    }
    this.id = initShim.id();
    this.simpleConditions = initShim.simpleConditions();
    this.initShim = null;
  }

  private ImmutableSearch(
      Integer id,
      String database,
      String name,
      List<SearchField> orderByFields,
      List<SearchField> outputFields,
      List<SearchCondition> simpleConditions,
      String type,
      String view) {
    this.id = id;
    this.database = database;
    this.name = name;
    this.orderByFields = orderByFields;
    this.outputFields = outputFields;
    this.simpleConditions = simpleConditions;
    this.type = type;
    this.view = view;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Search", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private Integer id;

    Integer id() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(idInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void id(Integer id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte simpleConditionsBuildStage = STAGE_UNINITIALIZED;
    private List<SearchCondition> simpleConditions;

    List<SearchCondition> simpleConditions() {
      if (simpleConditionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (simpleConditionsBuildStage == STAGE_UNINITIALIZED) {
        simpleConditionsBuildStage = STAGE_INITIALIZING;
        this.simpleConditions = simpleConditionsInitialize() instanceof Collection<?>
       ? List.copyOf((Collection<? extends SearchCondition>) simpleConditionsInitialize())
       : StreamSupport.stream(simpleConditionsInitialize().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
        simpleConditionsBuildStage = STAGE_INITIALIZED;
      }
      return this.simpleConditions;
    }

    void simpleConditions(List<SearchCondition> simpleConditions) {
      this.simpleConditions = simpleConditions;
      simpleConditionsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (simpleConditionsBuildStage == STAGE_INITIALIZING) attributes.add("simpleConditions");
      return "Cannot build Search, attribute initializers form cycle " + attributes;
    }
  }

  private Integer idInitialize() {
    return Search.super.id();
  }

  private List<SearchCondition> simpleConditionsInitialize() {
    return Search.super.simpleConditions();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public Integer id() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.id()
        : this.id;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @JsonProperty("database")
  @Override
  public String database() {
    return database;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code orderByFields} attribute
   */
  @JsonProperty("orderByFields")
  @Override
  public List<SearchField> orderByFields() {
    return orderByFields;
  }

  /**
   * @return The value of the {@code outputFields} attribute
   */
  @JsonProperty("outputFields")
  @Override
  public List<SearchField> outputFields() {
    return outputFields;
  }

  /**
   * @return The value of the {@code simpleConditions} attribute
   */
  @JsonProperty("simpleConditions")
  @Override
  public List<SearchCondition> simpleConditions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.simpleConditions()
        : this.simpleConditions;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty("view")
  @Override
  public String view() {
    return view;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableSearch(
        newValue,
        this.database,
        this.name,
        this.orderByFields,
        this.outputFields,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#database() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withDatabase(String value) {
    String newValue = Objects.requireNonNull(value, "database");
    if (this.database.equals(newValue)) return this;
    return new ImmutableSearch(
        this.id,
        newValue,
        this.name,
        this.orderByFields,
        this.outputFields,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSearch(
        this.id,
        this.database,
        newValue,
        this.orderByFields,
        this.outputFields,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Search#orderByFields() orderByFields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearch withOrderByFields(SearchField... elements) {
    List<SearchField> newValue = List.of(elements);
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        newValue,
        this.outputFields,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Search#orderByFields() orderByFields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of orderByFields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearch withOrderByFields(Iterable<? extends SearchField> elements) {
    if (this.orderByFields == elements) return this;
    List<SearchField> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends SearchField>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        newValue,
        this.outputFields,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Search#outputFields() outputFields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearch withOutputFields(SearchField... elements) {
    List<SearchField> newValue = List.of(elements);
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        this.orderByFields,
        newValue,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Search#outputFields() outputFields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of outputFields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearch withOutputFields(Iterable<? extends SearchField> elements) {
    if (this.outputFields == elements) return this;
    List<SearchField> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends SearchField>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        this.orderByFields,
        newValue,
        this.simpleConditions,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Search#simpleConditions() simpleConditions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearch withSimpleConditions(SearchCondition... elements) {
    List<SearchCondition> newValue = List.of(elements);
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        this.orderByFields,
        this.outputFields,
        newValue,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Search#simpleConditions() simpleConditions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of simpleConditions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearch withSimpleConditions(Iterable<? extends SearchCondition> elements) {
    if (this.simpleConditions == elements) return this;
    List<SearchCondition> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends SearchCondition>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        this.orderByFields,
        this.outputFields,
        newValue,
        this.type,
        this.view);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        this.orderByFields,
        this.outputFields,
        this.simpleConditions,
        newValue,
        this.view);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Search#view() view} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for view
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearch withView(String value) {
    String newValue = Objects.requireNonNull(value, "view");
    if (this.view.equals(newValue)) return this;
    return new ImmutableSearch(
        this.id,
        this.database,
        this.name,
        this.orderByFields,
        this.outputFields,
        this.simpleConditions,
        this.type,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearch} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearch
        && equalTo(0, (ImmutableSearch) another);
  }

  private boolean equalTo(int synthetic, ImmutableSearch another) {
    return id.equals(another.id)
        && database.equals(another.database)
        && name.equals(another.name)
        && orderByFields.equals(another.orderByFields)
        && outputFields.equals(another.outputFields)
        && simpleConditions.equals(another.simpleConditions)
        && type.equals(another.type)
        && view.equals(another.view);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code database}, {@code name}, {@code orderByFields}, {@code outputFields}, {@code simpleConditions}, {@code type}, {@code view}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + database.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + orderByFields.hashCode();
    h += (h << 5) + outputFields.hashCode();
    h += (h << 5) + simpleConditions.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + view.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Search} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Search{"
        + "id=" + id
        + ", database=" + database
        + ", name=" + name
        + ", orderByFields=" + orderByFields
        + ", outputFields=" + outputFields
        + ", simpleConditions=" + simpleConditions
        + ", type=" + type
        + ", view=" + view
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Search", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Search {
    @Nullable Integer id;
    @Nullable String database;
    @Nullable String name;
    @Nullable List<SearchField> orderByFields = List.of();
    @Nullable List<SearchField> outputFields = List.of();
    @Nullable List<SearchCondition> simpleConditions = List.of();
    boolean simpleConditionsIsSet;
    @Nullable String type;
    @Nullable String view;
    @JsonProperty("id")
    public void setId(Integer id) {
      this.id = id;
    }
    @JsonProperty("database")
    public void setDatabase(String database) {
      this.database = database;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("orderByFields")
    public void setOrderByFields(List<SearchField> orderByFields) {
      this.orderByFields = orderByFields;
    }
    @JsonProperty("outputFields")
    public void setOutputFields(List<SearchField> outputFields) {
      this.outputFields = outputFields;
    }
    @JsonProperty("simpleConditions")
    public void setSimpleConditions(List<SearchCondition> simpleConditions) {
      this.simpleConditions = simpleConditions;
      this.simpleConditionsIsSet = null != simpleConditions;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("view")
    public void setView(String view) {
      this.view = view;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public String database() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public List<SearchField> orderByFields() { throw new UnsupportedOperationException(); }
    @Override
    public List<SearchField> outputFields() { throw new UnsupportedOperationException(); }
    @Override
    public List<SearchCondition> simpleConditions() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public String view() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearch fromJson(Json json) {
    ImmutableSearch.Builder builder = ImmutableSearch.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.database != null) {
      builder.database(json.database);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.orderByFields != null) {
      builder.addAllOrderByFields(json.orderByFields);
    }
    if (json.outputFields != null) {
      builder.addAllOutputFields(json.outputFields);
    }
    if (json.simpleConditionsIsSet) {
      builder.addAllSimpleConditions(json.simpleConditions);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.view != null) {
      builder.view(json.view);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Search} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Search instance
   */
  public static ImmutableSearch copyOf(Search instance) {
    if (instance instanceof ImmutableSearch) {
      return (ImmutableSearch) instance;
    }
    return ImmutableSearch.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearch ImmutableSearch}.
   * <pre>
   * ImmutableSearch.builder()
   *    .id(Integer) // optional {@link Search#id() id}
   *    .database(String) // required {@link Search#database() database}
   *    .name(String) // required {@link Search#name() name}
   *    .addOrderByFields|addAllOrderByFields(zeenea.connector.denodo.client.rest.SearchField) // {@link Search#orderByFields() orderByFields} elements
   *    .addOutputFields|addAllOutputFields(zeenea.connector.denodo.client.rest.SearchField) // {@link Search#outputFields() outputFields} elements
   *    .addSimpleConditions|addAllSimpleConditions(zeenea.connector.denodo.client.rest.SearchCondition) // {@link Search#simpleConditions() simpleConditions} elements
   *    .type(String) // required {@link Search#type() type}
   *    .view(String) // required {@link Search#view() view}
   *    .build();
   * </pre>
   * @return A new ImmutableSearch builder
   */
  public static ImmutableSearch.Builder builder() {
    return new ImmutableSearch.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearch ImmutableSearch}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Search", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATABASE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_VIEW = 0x8L;
    private static final long OPT_BIT_SIMPLE_CONDITIONS = 0x1L;
    private long initBits = 0xfL;
    private long optBits;

    private @Nullable Integer id;
    private @Nullable String database;
    private @Nullable String name;
    private List<SearchField> orderByFields = new ArrayList<SearchField>();
    private List<SearchField> outputFields = new ArrayList<SearchField>();
    private List<SearchCondition> simpleConditions = new ArrayList<SearchCondition>();
    private @Nullable String type;
    private @Nullable String view;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Search} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Search instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      this.database(instance.database());
      this.name(instance.name());
      addAllOrderByFields(instance.orderByFields());
      addAllOutputFields(instance.outputFields());
      addAllSimpleConditions(instance.simpleConditions());
      this.type(instance.type());
      this.view(instance.view());
      return this;
    }

    /**
     * Initializes the value for the {@link Search#id() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Search#id() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(Integer id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link Search#database() database} attribute.
     * @param database The value for database 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder database(String database) {
      this.database = Objects.requireNonNull(database, "database");
      initBits &= ~INIT_BIT_DATABASE;
      return this;
    }

    /**
     * Initializes the value for the {@link Search#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Search#orderByFields() orderByFields} list.
     * @param element A orderByFields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOrderByFields(SearchField element) {
      this.orderByFields.add(Objects.requireNonNull(element, "orderByFields element"));
      return this;
    }

    /**
     * Adds elements to {@link Search#orderByFields() orderByFields} list.
     * @param elements An array of orderByFields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOrderByFields(SearchField... elements) {
      for (SearchField element : elements) {
        this.orderByFields.add(Objects.requireNonNull(element, "orderByFields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Search#orderByFields() orderByFields} list.
     * @param elements An iterable of orderByFields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderByFields(Iterable<? extends SearchField> elements) {
      this.orderByFields.clear();
      return addAllOrderByFields(elements);
    }

    /**
     * Adds elements to {@link Search#orderByFields() orderByFields} list.
     * @param elements An iterable of orderByFields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrderByFields(Iterable<? extends SearchField> elements) {
      for (SearchField element : elements) {
        this.orderByFields.add(Objects.requireNonNull(element, "orderByFields element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Search#outputFields() outputFields} list.
     * @param element A outputFields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOutputFields(SearchField element) {
      this.outputFields.add(Objects.requireNonNull(element, "outputFields element"));
      return this;
    }

    /**
     * Adds elements to {@link Search#outputFields() outputFields} list.
     * @param elements An array of outputFields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOutputFields(SearchField... elements) {
      for (SearchField element : elements) {
        this.outputFields.add(Objects.requireNonNull(element, "outputFields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Search#outputFields() outputFields} list.
     * @param elements An iterable of outputFields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputFields(Iterable<? extends SearchField> elements) {
      this.outputFields.clear();
      return addAllOutputFields(elements);
    }

    /**
     * Adds elements to {@link Search#outputFields() outputFields} list.
     * @param elements An iterable of outputFields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOutputFields(Iterable<? extends SearchField> elements) {
      for (SearchField element : elements) {
        this.outputFields.add(Objects.requireNonNull(element, "outputFields element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Search#simpleConditions() simpleConditions} list.
     * @param element A simpleConditions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSimpleConditions(SearchCondition element) {
      this.simpleConditions.add(Objects.requireNonNull(element, "simpleConditions element"));
      optBits |= OPT_BIT_SIMPLE_CONDITIONS;
      return this;
    }

    /**
     * Adds elements to {@link Search#simpleConditions() simpleConditions} list.
     * @param elements An array of simpleConditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSimpleConditions(SearchCondition... elements) {
      for (SearchCondition element : elements) {
        this.simpleConditions.add(Objects.requireNonNull(element, "simpleConditions element"));
      }
      optBits |= OPT_BIT_SIMPLE_CONDITIONS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Search#simpleConditions() simpleConditions} list.
     * @param elements An iterable of simpleConditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder simpleConditions(Iterable<? extends SearchCondition> elements) {
      this.simpleConditions.clear();
      return addAllSimpleConditions(elements);
    }

    /**
     * Adds elements to {@link Search#simpleConditions() simpleConditions} list.
     * @param elements An iterable of simpleConditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSimpleConditions(Iterable<? extends SearchCondition> elements) {
      for (SearchCondition element : elements) {
        this.simpleConditions.add(Objects.requireNonNull(element, "simpleConditions element"));
      }
      optBits |= OPT_BIT_SIMPLE_CONDITIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link Search#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Search#view() view} attribute.
     * @param view The value for view 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder view(String view) {
      this.view = Objects.requireNonNull(view, "view");
      initBits &= ~INIT_BIT_VIEW;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearch ImmutableSearch}.
     * @return An immutable instance of Search
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearch build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSearch(this);
    }

    private boolean simpleConditionsIsSet() {
      return (optBits & OPT_BIT_SIMPLE_CONDITIONS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATABASE) != 0) attributes.add("database");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VIEW) != 0) attributes.add("view");
      return "Cannot build Search, some of required attributes are not set " + attributes;
    }
  }
}
